/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.lifecycle;

import com.schneide.base.gui.lifecycle.ListenerRelation;
import com.schneide.base.gui.lifecycle.ListenerRelationHandler;
import com.schneide.base.gui.lifecycle.ListenerRelationLifecycleState;
import java.util.ArrayList;
import java.util.List;

public class GenericListenerRelationHandler
implements ListenerRelationHandler {
    private final List<ListenerRelation> listenerRelations = new ArrayList<ListenerRelation>();
    private ListenerRelationLifecycleState lifecycleState = ListenerRelationLifecycleState.BEFORE_SHOW;

    public ListenerRelationLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRelationsCount() {
        List<ListenerRelation> list = this.listenerRelations;
        synchronized (list) {
            return this.listenerRelations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListenerRelation(ListenerRelation relation) {
        if (null == relation) {
            return;
        }
        List<ListenerRelation> list = this.listenerRelations;
        synchronized (list) {
            if (ListenerRelationLifecycleState.AFTER_SHOW == this.lifecycleState) {
                return;
            }
            this.listenerRelations.add(relation);
            if (ListenerRelationLifecycleState.SHOWING == this.lifecycleState) {
                relation.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectListenerRelations() {
        List<ListenerRelation> list = this.listenerRelations;
        synchronized (list) {
            if (ListenerRelationLifecycleState.SHOWING == this.lifecycleState) {
                return;
            }
            if (ListenerRelationLifecycleState.BEFORE_SHOW != this.lifecycleState) {
                throw new IllegalStateException("Could not connect listener relations as lifecycle state is already " + String.valueOf((Object)this.lifecycleState));
            }
            this.lifecycleState = ListenerRelationLifecycleState.SHOWING;
            for (ListenerRelation relation : this.listenerRelations) {
                relation.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectListenerRelations() {
        List<ListenerRelation> list = this.listenerRelations;
        synchronized (list) {
            if (ListenerRelationLifecycleState.AFTER_SHOW == this.lifecycleState) {
                return;
            }
            if (ListenerRelationLifecycleState.SHOWING != this.lifecycleState) {
                throw new IllegalStateException("Could not disconnect listener relations as lifecycle state is still/already " + String.valueOf((Object)this.lifecycleState));
            }
            this.lifecycleState = ListenerRelationLifecycleState.AFTER_SHOW;
            for (ListenerRelation relation : this.listenerRelations) {
                relation.disconnect();
            }
        }
    }
}

