/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.image;

import com.schneide.base.maths.Percent;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public final class ImageScaler {
    private ImageScaler() {
    }

    public static BufferedImage getScaledWithRatio(BufferedImage original, Percent scaling) {
        int targetWidth = (int)scaling.multiplyWith(original.getWidth());
        int targetHeight = (int)scaling.multiplyWith(original.getHeight());
        return ImageScaler.getScaledInstance(original, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

