/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.image;

import com.schneide.base.gui.util.GraphicsConfigurationProvider;
import com.schneide.base.logging.LoggedObject;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageProducer
extends LoggedObject {
    public BufferedImage createCompatibleImage(int width, int height) {
        if (this.isHeadless()) {
            return new BufferedImage(width, height, 1);
        }
        return this.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public BufferedImage createCompatibleImage(int width, int height, int transparency) {
        if (this.isHeadless()) {
            return new BufferedImage(width, height, 2);
        }
        return this.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
    }

    protected GraphicsConfiguration getGraphicsConfiguration() {
        return new GraphicsConfigurationProvider().getGraphicsConfiguration();
    }

    protected boolean isHeadless() {
        return new GraphicsConfigurationProvider().isHeadless();
    }

    public BufferedImage createBufferedImageFrom(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage compatibleImage = this.bufferedImageFor(image);
        Graphics graphics = compatibleImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return compatibleImage;
    }

    public BufferedImage createBufferedImageFrom(RenderedImage image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ColorModel colorModel = image.getColorModel();
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster raster = colorModel.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = colorModel.isAlphaPremultiplied();
        BufferedImage result = new BufferedImage(colorModel, raster, isAlphaPremultiplied, this.propertiesOf(image));
        image.copyData(raster);
        return result;
    }

    private Hashtable<String, Object> propertiesOf(RenderedImage image) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        String[] keys = image.getPropertyNames();
        if (keys != null) {
            for (String each : keys) {
                result.put(each, image.getProperty(each));
            }
        }
        return result;
    }

    protected BufferedImage bufferedImageFor(Image realImage) {
        int width = realImage.getWidth(null);
        int height = realImage.getHeight(null);
        if (this.hasTransparency(realImage)) {
            return this.createCompatibleImage(width, height, 3);
        }
        return this.createCompatibleImage(width, height);
    }

    public boolean hasTransparency(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber probe = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            if (!probe.grabPixels()) {
                return false;
            }
            return probe.getColorModel().hasAlpha();
        }
        catch (InterruptedException e) {
            this.getLogger().warn("Could not determine image transparency, was interrupted.", e);
            return false;
        }
    }
}

