/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.question;

import com.schneide.base.gui.GenericWindowStack;
import com.schneide.base.gui.dialog.generic.GenericStringInputDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.model.WindowStackProvider;
import com.schneide.base.i18n.I18NKey;
import java.util.Optional;

public class StringInputDialogBuilder {
    private String defaultValue = "";
    private I18NKey i18nBase = new I18NKey("StringInputDialogBuilder.default");

    public StringInputDialogBuilder withTextFrom(I18NKey i18n) {
        this.i18nBase = i18n;
        return this;
    }

    public StringInputDialogBuilder andInitialValue(String initialValue) {
        return this.withInitialValue(initialValue);
    }

    public StringInputDialogBuilder withInitialValue(String initialValue) {
        this.defaultValue = initialValue;
        return this;
    }

    public Optional<String> onTopOf(WindowStackProvider windows) {
        return this.onTopOf(windows.getMainWindowStack());
    }

    public Optional<String> onTopOf(WindowStack windows) {
        GenericStringInputDialog dialog = new GenericStringInputDialog(this.onto(windows), this.i18nBase, "textbox", this.defaultValue);
        dialog.showDialog();
        if (!dialog.wasClosedByCommit()) {
            return Optional.empty();
        }
        return Optional.of(dialog.getValue());
    }

    protected WindowStack onto(WindowStack windows) {
        if (null == windows) {
            return GenericWindowStack.getParentlessWindowStack();
        }
        return windows;
    }
}

