/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.generic;

import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.EmptyText;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.maths.Percent;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SessionlessProgressDialog
extends AbstractSchneideDialog<Void> {
    private boolean isDeterminate;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private String forcedMessage;
    private String forcedTitle;

    public SessionlessProgressDialog(WindowStack windowStack, boolean isDeterminate) {
        this(windowStack, new EmptyText(), isDeterminate);
    }

    public SessionlessProgressDialog(WindowStack windowStack, I18NResolvable baseKey, boolean isDeterminate) throws IllegalArgumentException {
        this(windowStack, baseKey, isDeterminate, false);
    }

    protected SessionlessProgressDialog(WindowStack windowStack, I18NResolvable baseKey, boolean isDeterminate, boolean isModal) throws IllegalArgumentException {
        super(windowStack, (I18NKeyed)baseKey, isModal);
        this.isDeterminate = isDeterminate;
        this.forcedMessage = null;
        this.forcedTitle = null;
    }

    @Override
    protected void buildUI() {
        JPanel contentPanel = new JPanel(new StringGridBagLayout());
        this.progressLabel = new JLabel(this.getProgressLabelText());
        this.progressBar = new JProgressBar();
        this.setDeterminate(this.isDeterminate);
        contentPanel.add("gridx=0,gridy=0,anchor=CENTER,insets=[10,10,10,10]", this.progressLabel);
        contentPanel.add("gridx=0,gridy=1,anchor=CENTER,insets=[10,10,10,10],fill=HORIZONTAL", this.progressBar);
        this.setContent(contentPanel);
        if (null != this.forcedTitle) {
            this.setTitle(this.forcedTitle);
        }
        this.addButton().commitCancelButtons();
        this.getCommitButton().setHidden(true);
    }

    protected String getProgressLabelText() {
        if (null == this.forcedMessage) {
            return this.getTextEntry("label.text");
        }
        return this.forcedMessage;
    }

    public void setProgress(Percent progress) {
        this.progressBar.setValue((int)progress.getValue());
    }

    public void setMessage(String message) {
        if (null != this.progressLabel) {
            this.progressLabel.setText(message);
        }
        this.forcedMessage = message;
    }

    public void setMessage(I18NResolvable message) {
        this.setMessage(message.resolvedText());
    }

    public void changeTitle(String title) {
        if (this.isBuilt()) {
            super.setTitle(title);
        }
        this.forcedTitle = title;
    }

    public void setDeterminate(boolean value) {
        this.isDeterminate = value;
        this.progressBar.setIndeterminate(!this.isDeterminate);
    }

    @Override
    protected Optional<Void> giveAnswer() {
        return Optional.empty();
    }
}

