/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.generic;

import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.types.StringValue;
import com.schneide.base.input.types.i18n.DefaultI18NValueInformation;
import com.schneide.base.input.types.i18n.DirectValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import java.util.Optional;

public class GenericStringInputDialog
extends AbstractSchneideDialog<String> {
    private final StringValue stringValue;

    public GenericStringInputDialog(WindowStack session, I18NKey i18nBaseKey, String valueI18N) {
        this(session, i18nBaseKey, valueI18N, null);
    }

    public GenericStringInputDialog(WindowStack session, I18NKey i18nBaseKey, String valueI18N, String initialValue) {
        this(session, i18nBaseKey, new DefaultI18NValueInformation(i18nBaseKey.withKeyPart(valueI18N)), initialValue);
    }

    public GenericStringInputDialog(WindowStack session, I18NKey i18nBaseKey, ValueInformation valueInformation, String initialValue) {
        super(session, i18nBaseKey);
        this.stringValue = new StringValue(valueInformation, initialValue);
        this.initializeAdditional();
    }

    public GenericStringInputDialog(WindowStack session, I18NResolvable title, I18NResolvable message, String eingabename, String initialValue) {
        super(session, "");
        this.stringValue = new StringValue((ValueInformation)new DirectValueInformation(eingabename, " "), initialValue);
        this.setTitle(title);
        this.addMessage(message);
        this.initializeAdditional();
    }

    protected StringValue getStringValue() {
        return this.stringValue;
    }

    protected void initializeAdditional() {
    }

    @Override
    protected void buildUI() {
        this.buildDefaultI18NInputDialog(this.stringValue);
    }

    public String getValue() {
        return this.getStringValue().getValue();
    }

    @Override
    protected Optional<String> giveAnswer() {
        return Optional.ofNullable(this.getValue());
    }
}

