/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.factory.touchscreen;

import com.schneide.base.gui.SetWidth;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.factory.SchneideDialogFactory;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.inputs.touchscreen.helper.DeriveTouchscreenFont;
import com.schneide.base.input.inputs.touchscreen.helper.TouchscreenConstants;
import java.util.Optional;
import javax.swing.BorderFactory;

public class TouchscreenSchneideDialogFactory
implements SchneideDialogFactory {
    private static final String YES = new NotI18NYet("Ja", new Object[0]).text();
    private static final String NO = new NotI18NYet("Nein", new Object[0]).text();

    @Override
    public boolean warningConfirmationDialog(WindowStack windowStack, final I18NResolvable baseKey) {
        AbstractSchneideDialog<Boolean> dialog = new AbstractSchneideDialog<Boolean>(this, windowStack, (I18NKeyed)baseKey){

            @Override
            protected void buildUI() {
                this.addMessage(new I18NText(baseKey.getI18NKey().withKeyPart("message"), baseKey.getParameters()).resolvedText());
                this.addButton().commitButton(YES, YES);
                this.addButton().cancelButton(NO, NO);
                this.getCommitButton().setBorder(BorderFactory.createCompoundBorder(this.getCommitButton().getBorder(), TouchscreenConstants.EMPTY_BORDER));
                this.getCommitButton().setFont(DeriveTouchscreenFont.from(this.getCommitButton().getFont()));
                this.getCancelButton().setBorder(BorderFactory.createCompoundBorder(this.getCancelButton().getBorder(), TouchscreenConstants.EMPTY_BORDER));
                this.getCancelButton().setFont(DeriveTouchscreenFont.from(this.getCancelButton().getFont()));
                SetWidth.of(this.getCommitButton(), this.getCancelButton()).toTheirMaximum();
            }

            @Override
            protected Optional<Boolean> giveAnswer() {
                return Optional.of(this.wasClosedByCommit());
            }
        };
        return dialog.showDialog().orElse(false);
    }
}

