/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.timed;

import com.schneide.base.gui.dialog.GenericDialogOption;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.dialog.defaults.DialogOptionWrapping;
import com.schneide.base.gui.dialog.model.DialogOption;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.threading.DelayedExecutable;
import com.schneide.base.threading.DelayedLoopingExecutable;
import com.schneide.base.threading.delay.LeadingDelay;
import javax.measure.Measurable;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jscience.physics.amount.Amount;

public final class TimedOrdinaryDialog {
    private TimedOrdinaryDialog() {
    }

    public static void showErrorDialog(WindowStack windowStack, Measurable<Duration> waitOnUser, String title, String message) {
        TimedOrdinaryDialog.showDialogForDuration(windowStack, waitOnUser, title, message, 0, -1, new GenericDialogOption(new DirectText("Best\u00e4tigen").resolvedText()));
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, Measurable<Duration> waitOnUser, I18NKey i18nKey, DialogOption[] options, Object ... parameters) {
        return TimedOrdinaryDialog.showErrorOptionDialog(windowStack, waitOnUser, I18NKey.buildFromContext(i18nKey, "title"), I18NKey.buildFromContext(i18nKey, "message"), options, parameters);
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, Measurable<Duration> waitOnUser, I18NKey titleKey, I18NKey messageKey, DialogOption[] options, Object ... parameters) {
        return TimedOrdinaryDialog.showErrorOptionDialog(windowStack, waitOnUser, new I18NText(titleKey, parameters), new I18NText(messageKey, parameters), options);
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, Measurable<Duration> waitOnUser, I18NResolvable titleSpecification, I18NResolvable messageSpecification, DialogOption ... options) {
        return TimedOrdinaryDialog.showErrorOptionDialogForDuration(windowStack, waitOnUser, titleSpecification.resolvedText(), messageSpecification.resolvedText(), options);
    }

    protected static String getMessageWithTimer(String message, Measurable<Duration> remainingWait) {
        return message + "\n\n" + new DirectText("Verbleibende Wartezeit: ").resolvedText() + String.valueOf(remainingWait);
    }

    protected static DialogOption showDialogForDuration(WindowStack windowStack, Measurable<Duration> waitOnUser, String title, String message, int messageType, int optionType, DialogOption ... options) {
        final DialogOptionWrapping wrapping = new DialogOptionWrapping(options);
        final JOptionPane pane = new JOptionPane(TimedOrdinaryDialog.getMessageWithTimer(message, waitOnUser), optionType, messageType, null, wrapping.getOptions(), wrapping.getDefaultOption());
        pane.setInitialValue(wrapping.getDefaultOption());
        final JDialog dialog = pane.createDialog(windowStack.getActiveWindow(), title);
        pane.selectInitialValue();
        final TimerMessageUpdater messageUpdater = new TimerMessageUpdater(pane, message, waitOnUser);
        DelayedExecutable closer = new DelayedExecutable("TimedDialog closer", new LeadingDelay(waitOnUser)){

            @Override
            protected void executeFunctionality() {
                messageUpdater.stopExecution();
                pane.setValue(wrapping.getDefaultOption());
                dialog.setVisible(false);
            }
        };
        messageUpdater.startExecution();
        closer.startExecution();
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue instanceof DefaultDialog.DialogOptionWrapper) {
            return ((DefaultDialog.DialogOptionWrapper)selectedValue).getOption();
        }
        return (DialogOption)selectedValue;
    }

    public static DialogOption showErrorOptionDialogForDuration(WindowStack windowStack, Measurable<Duration> waitOnUser, String title, String message, DialogOption ... options) {
        return TimedOrdinaryDialog.showDialogForDuration(windowStack, waitOnUser, title, message, 0, 1, options);
    }

    protected static class TimerMessageUpdater
    extends DelayedLoopingExecutable {
        private final JOptionPane pane;
        private final String message;
        private Measurable<Duration> currentWait;

        public TimerMessageUpdater(JOptionPane pane, String message, Measurable<Duration> initialWait) {
            super("TimedDialog message timer updater", new LeadingDelay(1000L));
            this.pane = pane;
            this.message = message;
            this.currentWait = initialWait;
        }

        @Override
        protected void executeWithinLoop() throws Exception {
            this.currentWait = Amount.valueOf((long)(this.currentWait.longValue((Unit)SI.SECOND) - 1L), (Unit)SI.SECOND);
            EDT.later(() -> this.pane.setMessage(TimedOrdinaryDialog.getMessageWithTimer(this.message, this.currentWait)));
        }
    }
}

