/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.fancy;

import com.schneide.base.gui.dialog.defaults.fancy.DialogType;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.text.transformation.LineBreaker;

public class GenericDialogInformation
implements FancyDialogInformation {
    private String details;
    private String headline;
    private String message;
    private String title;
    private DialogType type;

    public GenericDialogInformation() {
        this("", "", "", "", DialogType.ERROR);
    }

    public GenericDialogInformation(String title, String headline, String message, String details, DialogType type) {
        this.title = title;
        this.message = message;
        this.headline = headline;
        this.details = details;
        this.type = type;
    }

    public GenericDialogInformation forType(DialogType newType) {
        return new GenericDialogInformation(this.title, this.message, this.headline, this.details, newType);
    }

    public GenericDialogInformation withTitle(I18Nable newTitle) {
        return this.withTitle(newTitle.resolvedText());
    }

    public GenericDialogInformation withTitle(String newTitle) {
        this.setTitle(newTitle);
        return this;
    }

    public GenericDialogInformation withMessage(I18Nable newMessage) {
        return this.withMessage(newMessage.resolvedText());
    }

    public GenericDialogInformation withMessage(String newMessage) {
        this.setMessage(newMessage);
        return this;
    }

    public GenericDialogInformation withWrappedMessage(I18Nable newMessage, int maximalLineLength) {
        return this.withWrappedMessage(newMessage.resolvedText(), maximalLineLength);
    }

    public GenericDialogInformation withWrappedMessage(String newMessage, int maximalLineLength) {
        return this.withMessage(new LineBreaker(maximalLineLength).getWrapped(newMessage));
    }

    public GenericDialogInformation withHeadline(I18Nable newHeadline) {
        return this.withHeadline(newHeadline.resolvedText());
    }

    public GenericDialogInformation withHeadline(String newHeadline) {
        this.setHeadline(newHeadline);
        return this;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    @Override
    public String getHeadline() {
        return this.headline;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public DialogType getType() {
        return this.type;
    }

    public void setType(DialogType type) {
        this.type = type;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDetails(I18Nable details) {
        this.details = details.resolvedText();
    }

    public void setHeadline(I18Nable headline) {
        this.headline = headline.resolvedText();
    }

    public void setMessage(I18Nable message) {
        this.message = message.resolvedText();
    }

    public void setTitle(I18Nable title) {
        this.title = title.resolvedText();
    }
}

