/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.fancy;

import com.ezware.common.Markup;
import com.ezware.dialog.task.TaskDialog;
import com.schneide.base.gui.dialog.defaults.fancy.DialogType;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.gui.dialog.defaults.fancy.GenericDialogInformation;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.text.StringUtil;
import com.schneide.base.threading.SchneideThread;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FancyDialog {
    private final FancyDialogInformation textProvider;
    private TaskDialog dialog;
    private boolean isBuilt;

    public FancyDialog(String title, String headline, String message, String details, DialogType type) {
        this(new GenericDialogInformation(title, message, headline, details, type));
    }

    public FancyDialog(FancyDialogInformation textProvider) {
        EDT.whatever();
        this.isBuilt = false;
        this.textProvider = textProvider;
    }

    protected final TaskDialog getTaskDialog() {
        EDT.only();
        if (null == this.dialog) {
            this.prepareUI();
        }
        return this.dialog;
    }

    protected void buildUI() {
        EDT.only();
        this.dialog = new TaskDialog(this.textProvider.getTitle());
        this.init();
    }

    protected void init() {
        EDT.only();
        this.getTaskDialog().setIcon(this.textProvider.getType().getIcon());
        this.getTaskDialog().setInstruction(this.textProvider.getHeadline());
        this.getTaskDialog().setText(this.textProvider.getMessage());
        if (!StringUtil.isEmptyOrNull(this.textProvider.getDetails())) {
            this.getTaskDialog().getDetails().setExpandableComponent((JComponent)new JLabel(Markup.toHTML((String)this.textProvider.getDetails())));
            this.getTaskDialog().getDetails().setExpanded(false);
        }
    }

    protected void prepareUI() {
        EDT.whatever();
        if (!this.isBuilt) {
            EDT.performBlocking(() -> this.buildUI());
            this.isBuilt = true;
        }
    }

    public void show() {
        EDT.whatever();
        this.prepareUI();
        EDT.performBlocking(() -> {
            this.afterInitBeforeShow();
            this.getTaskDialog().setVisible(true);
        });
        this.waitUntilClosed();
    }

    protected void waitUntilClosed() {
        TaskDialog shownDialog = EDT.query(() -> this.getTaskDialog());
        while (shownDialog.isVisible()) {
            SchneideThread.performDelay(10L);
        }
    }

    protected FancyDialogInformation getTextProvider() {
        return this.textProvider;
    }

    protected void afterInitBeforeShow() {
    }
}

