/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.fancy;

import com.schneide.base.gui.dialog.defaults.fancy.DialogType;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.io.reader.LineBuilder;
import com.schneide.base.text.Text;
import java.text.MessageFormat;

public class ExceptionTextProvider
implements FancyDialogInformation {
    private final Throwable exception;
    private final I18NResolvable message;
    private I18NResolvable title;

    public ExceptionTextProvider(Throwable exception, I18NResolvable message) {
        this.message = message;
        this.exception = exception;
        this.title = new DirectText("Programmfehler");
    }

    public void setTitle(I18NResolvable title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title.resolvedText();
    }

    @Override
    public String getMessage() {
        return new DirectText("Fehlermeldung: <b>{0}</b>\n\n<i>Der Fehlerumstand wurde in den Logdateien gespeichert.</i>", this.exceptionMessage()).resolvedText();
    }

    protected String exceptionMessage() {
        if (null == this.exception) {
            return new NotI18NYet("keine", new Object[0]).text();
        }
        return Text.restrictTo(150, this.exception.getMessage());
    }

    @Override
    public String getHeadline() {
        return this.message.resolvedText();
    }

    @Override
    public String getDetails() {
        LineBuilder detailMessage = new LineBuilder();
        detailMessage.addLine(MessageFormat.format("<b>{0}</b>", this.exception.getClass().getName()));
        for (StackTraceElement stackTraceElement : this.exception.getStackTrace()) {
            detailMessage.addLine(stackTraceElement.toString());
        }
        return detailMessage.getText();
    }

    @Override
    public DialogType getType() {
        return DialogType.ERROR;
    }
}

