/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults;

import com.schneide.base.gui.dialog.defaults.RawQuestionDialog;
import com.schneide.base.gui.dialog.model.DialogOption;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;

public final class QuestionDialog {
    private QuestionDialog() {
    }

    public static DialogOption showQuestionDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message, DialogOption ... options) {
        return RawQuestionDialog.showQuestionDialog(windowStack, title.resolvedText(), message.resolvedText(), options);
    }

    public static DialogOption showQuestionDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, DialogOption[] options, Object ... parameters) {
        return RawQuestionDialog.showQuestionDialog(windowStack, new I18NText(titleKey, parameters).resolvedText(), new I18NText(messageKey, parameters).resolvedText(), options);
    }

    public static DialogOption showQuestionDialog(WindowStack windowStack, I18NKey i18nKey, DialogOption[] options, Object ... parameters) {
        return QuestionDialog.showQuestionDialog(windowStack, I18NKey.buildFromContext(i18nKey, "title"), I18NKey.buildFromContext(i18nKey, "message"), options, parameters);
    }

    public static DialogOption showQuestionOptionDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, DialogOption[] options, Object ... parameters) {
        return RawQuestionDialog.showQuestionOptionDialog(windowStack, new I18NText(titleKey, parameters).resolvedText(), new I18NText(messageKey, parameters).resolvedText(), options);
    }

    public static DialogOption showQuestionOptionDialog(WindowStack windowStack, I18NKey i18nKey, DialogOption[] options, Object ... parameters) {
        return QuestionDialog.showQuestionOptionDialog(windowStack, I18NKey.buildFromContext(i18nKey, "title"), I18NKey.buildFromContext(i18nKey, "message"), options, parameters);
    }

    public static boolean showWarningConfirmationDialog(WindowStack windowStack, I18NKey i18nKey, Object ... parameters) {
        return RawQuestionDialog.showWarningConfirmationDialog(windowStack, new I18NText(I18NKey.buildFromContext(i18nKey, "title"), parameters).resolvedText(), new I18NText(I18NKey.buildFromContext(i18nKey, "message"), parameters).resolvedText());
    }

    public static boolean showWarningConfirmationDialog(WindowStack windowStack, I18NResolvable baseKey) {
        return RawQuestionDialog.showWarningConfirmationDialog(windowStack, new I18NText(baseKey.getI18NKey().withKeyPart("title"), baseKey.getParameters()).resolvedText(), new I18NText(baseKey.getI18NKey().withKeyPart("message"), baseKey.getParameters()).resolvedText());
    }

    public static boolean showWarningConfirmationDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message) {
        return QuestionDialog.showWarningConfirmationDialog(windowStack, title, message, QuestionDefault.YES_BUTTON);
    }

    public static boolean showWarningConfirmationDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message, QuestionDefault defaultButton) {
        return RawQuestionDialog.showWarningConfirmationDialog(windowStack, title.resolvedText(), message.resolvedText(), defaultButton);
    }

    public static boolean showYesNoDecisionDialog(WindowStack windowStack, I18NKey i18nKey, Object ... parameters) {
        return QuestionDialog.showYesNoDecisionDialog(windowStack, new I18NText(I18NKey.buildFromContext(i18nKey, "title"), parameters), new I18NText(I18NKey.buildFromContext(i18nKey, "message"), parameters));
    }

    public static boolean showYesNoDecisionDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message) {
        return RawQuestionDialog.showYesNoDecisionDialog(windowStack, title.resolvedText(), message.resolvedText());
    }

    public static boolean showOkCancelDecisionDialog(WindowStack windowStack, I18NKey i18nKey, Object ... parameters) {
        return QuestionDialog.showOkCancelDecisionDialog(windowStack, new I18NText(I18NKey.buildFromContext(i18nKey, "title"), parameters), new I18NText(I18NKey.buildFromContext(i18nKey, "message"), parameters));
    }

    public static boolean showOkCancelDecisionDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message) {
        return RawQuestionDialog.showOkCancelDecisionDialog(windowStack, title.resolvedText(), message.resolvedText());
    }

    public static enum QuestionDefault {
        YES_BUTTON(new DirectText("Ja").resolvedText()),
        NO_BUTTON(new DirectText("Nein").resolvedText());

        private final String option;

        private QuestionDefault(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }

        public static String[] getAllOptions() {
            QuestionDefault[] values = QuestionDefault.values();
            String[] result = new String[values.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = values[i].getOption();
            }
            return result;
        }
    }
}

