/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.button;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public enum DialogButtonType {
    COMMIT_BUTTON(0, false),
    OPTIONAL_BUTTON(1, false),
    CANCEL_BUTTON(2, true),
    CLOSE_BUTTON(3, true);

    private final boolean required;
    private final int orderIndex;

    private DialogButtonType(int orderIndex, boolean required) {
        this.orderIndex = orderIndex;
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public static Iterable<DialogButtonType> inOrder() {
        ArrayList<DialogButtonType> result = new ArrayList<DialogButtonType>();
        Collections.addAll(result, DialogButtonType.values());
        Collections.sort(result, DialogButtonType.naturalComparator());
        return result;
    }

    public static Comparator<DialogButtonType> naturalComparator() {
        return (o1, o2) -> o1.orderIndex - o2.orderIndex;
    }
}

