/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.button;

import com.schneide.base.datatypes.collections.iterable.CollectionIterable;
import com.schneide.base.gui.dialog.DialogNotification;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.gui.dialog.button.DialogButtonType;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.logging.implementation.Log4jSchneideLogger;
import com.schneide.base.threading.ThreadMutex;
import com.schneide.base.util.Parameter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DialogButtonManager
extends LoggedObject
implements ActionListener {
    private static final Border BUTTON_PANEL_BORDER = BorderFactory.createEmptyBorder(17, 5, 11, 11);
    private static final Dimension BUTTON_SPACER = new Dimension(5, 0);
    private final Set<DialogButton> buttons;
    private final List<TypedDialogButton> buttonList;
    private final DialogNotification notification;
    private final ThreadMutex lock;
    private JButton helpButton;

    public DialogButtonManager() {
        this(null);
    }

    public DialogButtonManager(DialogNotification notification) {
        this.notification = notification;
        this.buttons = new HashSet<DialogButton>();
        this.buttonList = new ArrayList<TypedDialogButton>();
        this.lock = new ThreadMutex();
        this.helpButton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            this.buttons.clear();
            this.buttonList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addButton(DialogButton button, DialogButtonType type) {
        Parameter.arePresent(button);
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            this.buttons.add(button);
            this.buttonList.add(new TypedDialogButton(button, type));
        }
        button.addActionListener(this);
    }

    public void setHelpButton(JButton helpButton) {
        this.helpButton = helpButton;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof DialogButton) {
            DialogButton source = (DialogButton)event.getSource();
            try {
                DialogButtonHandler buttonHandler = this.getButtonHandlerFor(source);
                boolean closeDialog = buttonHandler.handleDialogButtonActivation(source);
                if (closeDialog && this.notification != null && this.notification.wantsToCloseWith(source)) {
                    this.notification.closeDialog(source);
                }
            }
            catch (NoSuchElementException e) {
                this.getLogger().warn("Did not find any handler for this button: " + String.valueOf(event.getSource()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasButtons() {
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            return !this.buttons.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasButtonHandler(DialogButton button) {
        if (null == button) {
            return false;
        }
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            return this.buttons.contains(button);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogButtonHandler getButtonHandlerFor(DialogButton button) throws NoSuchElementException {
        Parameter.isPresent(button);
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            if (!this.hasButtonHandler(button)) {
                throw new NoSuchElementException("Kein ButtonHandler gefunden.");
            }
            return button;
        }
    }

    public JPanel getButtonPanel() {
        Iterable<DialogButton> visibleButtons = this.getVisibleButtons();
        if (!this.hasARequiredButton()) {
            Log4jSchneideLogger.getLogger(this).error("This dialog " + this.getClass().getName() + " needs at least one required button");
        }
        return this.createButtonPanelFor(visibleButtons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasARequiredButton() {
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            for (TypedDialogButton button : this.buttonList) {
                if (!button.getType().isRequired()) continue;
                return true;
            }
        }
        return false;
    }

    protected JPanel createButtonPanelFor(Iterable<DialogButton> visibleButtons) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.setBorder(BUTTON_PANEL_BORDER);
        if (null != this.helpButton) {
            result.add(this.helpButton);
        }
        result.add(Box.createHorizontalGlue());
        this.addButtonsToPanel(visibleButtons, result);
        return result;
    }

    protected void addButtonsToPanel(Iterable<DialogButton> visibleButtons, JPanel result) {
        boolean needsSpacer = false;
        for (DialogButton dialogButton : visibleButtons) {
            if (needsSpacer) {
                result.add(Box.createRigidArea(BUTTON_SPACER));
            }
            result.add(dialogButton);
            needsSpacer = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<DialogButton> getVisibleButtons() {
        ArrayList<DialogButton> result = new ArrayList<DialogButton>();
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            Collections.sort(this.buttonList, new TypedDialogButtonComparator());
            for (TypedDialogButton typedDialogButton : this.buttonList) {
                DialogButton button = typedDialogButton.getButton();
                if (button.isHidden()) continue;
                result.add(button);
            }
        }
        return new CollectionIterable<DialogButton>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogButton getButtonBy(DialogButtonType type) {
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            for (TypedDialogButton button : this.buttonList) {
                if (type != button.getType()) continue;
                return button.getButton();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogButton getRequiredButton() {
        ThreadMutex threadMutex = this.lock;
        synchronized (threadMutex) {
            for (TypedDialogButton button : this.buttonList) {
                if (!button.getType().isRequired()) continue;
                return button.getButton();
            }
        }
        return null;
    }

    private static class TypedDialogButton {
        private final DialogButton button;
        private final DialogButtonType type;

        public TypedDialogButton(DialogButton button, DialogButtonType type) {
            this.button = button;
            this.type = type;
        }

        public DialogButton getButton() {
            return this.button;
        }

        public DialogButtonType getType() {
            return this.type;
        }
    }

    private static class TypedDialogButtonComparator
    implements Comparator<TypedDialogButton> {
        @Override
        public int compare(TypedDialogButton button1, TypedDialogButton button2) {
            return DialogButtonType.naturalComparator().compare(button1.getType(), button2.getType());
        }
    }
}

