/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog;

import com.schneide.base.gui.GUITools;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.DialogMessage;
import com.schneide.base.gui.dialog.DialogNotification;
import com.schneide.base.gui.dialog.MessageManager;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.DialogButtonManager;
import com.schneide.base.gui.dialog.button.DialogButtonType;
import com.schneide.base.gui.dialog.model.DialogButtonHook;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.input.inputs.generic.DialogCleanupHandler;
import com.schneide.base.system.Base;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

class SwingInternalSchneideDialog<ANSWER>
extends WindowAdapter {
    private static final Border CENTER_PANEL_BORDER = BorderFactory.createEmptyBorder(0, 12, 0, 12);
    private final JDialog dialog;
    private final AbstractSchneideDialog<ANSWER> boundDialog;
    private WindowStack windowStack;
    private DialogButtonManager buttonManager;
    private MessageManager messageManager;
    private JPanel centerPanel;
    private DialogButton wasClosedBy;
    private boolean isBuilt;
    private boolean nonCollapsable;

    public SwingInternalSchneideDialog(Dialog parent, WindowStack session, String title, DialogNotification notification, AbstractSchneideDialog<ANSWER> boundDialog) {
        this.boundDialog = boundDialog;
        this.dialog = new JDialog(parent, title, true);
        this.initDialog(session, notification);
    }

    public SwingInternalSchneideDialog(Frame parent, WindowStack windowStack, String title, DialogNotification notification, AbstractSchneideDialog<ANSWER> boundDialog) {
        this.boundDialog = boundDialog;
        this.dialog = new JDialog(parent, title, true);
        this.initDialog(windowStack, notification);
    }

    private void initDialog(WindowStack currentWindowStack, DialogNotification notification) {
        this.windowStack = currentWindowStack;
        this.wasClosedBy = null;
        this.buttonManager = new DialogButtonManager(notification);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this);
        this.messageManager = new MessageManager();
        this.setDialogContent(new JPanel());
        this.isBuilt = false;
        this.nonCollapsable = false;
    }

    public static String getDefaultCommitButtonTitle() {
        return Base.getTextContent().getText("dialog.default.button.commit.title");
    }

    public static String getDefaultCancelButtonTitle() {
        return Base.getTextContent().getText("dialog.default.button.cancel.title");
    }

    public static String getDefaultCloseButtonTitle() {
        return Base.getTextContent().getText("dialog.default.button.close.title");
    }

    public WindowStack getWindowStack() {
        return this.windowStack;
    }

    protected void setWindowStack(WindowStack windowStack) {
        this.windowStack = windowStack;
    }

    public void setHelpButton(JButton helpButton) {
        this.buttonManager.setHelpButton(helpButton);
    }

    public final void setDialogContent(JPanel contentPanel) {
        contentPanel.setBorder(CENTER_PANEL_BORDER);
        this.centerPanel = contentPanel;
    }

    public final JPanel getDialogContent() {
        return this.centerPanel;
    }

    public void addButton(DialogButton button, DialogButtonType type) {
        this.buttonManager.addButton(button, type);
    }

    public void setDefaultButton(DialogButton button) {
        if (this.buttonManager.hasButtonHandler(button)) {
            this.dialog.getRootPane().setDefaultButton(button);
        }
    }

    public DialogButton getCommitButton() {
        return this.getButtonBy(DialogButtonType.COMMIT_BUTTON);
    }

    public DialogButton getCancelButton() {
        return this.getButtonBy(DialogButtonType.CANCEL_BUTTON);
    }

    public DialogButton getCloseButton() {
        return this.getButtonBy(DialogButtonType.CLOSE_BUTTON);
    }

    public void addMessage(String message) {
        this.addMessage(new DialogMessage(message));
    }

    public void addMessage(String message, Color color) {
        this.addMessage(new DialogMessage(message, color));
    }

    public void addMessage(DialogMessage message) {
        this.messageManager.addMessage(message);
    }

    public void showDialog() {
        this.buildContent();
        this.pack();
        if (this.nonCollapsable) {
            this.dialog.setMinimumSize(this.dialog.getPreferredSize());
        }
        this.boundDialog.arrangeUI();
        this.setAppropriateLocation();
        this.dialog.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    public void setVisible(boolean visibility) {
        if (visibility) {
            this.showDialog();
        } else {
            this.dialog.setVisible(false);
        }
    }

    public void setName(String newName) {
        EDT.only();
        this.dialog.setName(newName);
    }

    private void buildContent() {
        if (this.isBuilt) {
            return;
        }
        this.isBuilt = true;
        JPanel messagePanel = this.messageManager.getMessagePanel();
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("", "0[grow, fill]0", "0[][grow,fill][]0"));
        contentPane.add((Component)messagePanel, "wrap");
        contentPane.add((Component)this.centerPanel, "wrap");
        JPanel buttonPanel = this.buttonManager.getButtonPanel();
        if (null != buttonPanel) {
            contentPane.add((Component)buttonPanel, "align right");
        }
        if (this.getCloseButton() != null) {
            this.setDefaultButton(this.getCloseButton());
        } else {
            this.setDefaultButton(this.getCommitButton());
        }
    }

    public void closeDialog(DialogButton button) {
        if (null == button) {
            return;
        }
        this.wasClosedBy = button;
        DialogCleanupHandler cleanupHandler = new DialogCleanupHandler();
        cleanupHandler.performCleanupFor(this.dialog.getContentPane());
        this.dialog.dispose();
        this.notifyButtonHooks(this.wasClosedBy);
    }

    private void notifyButtonHooks(DialogButton button) {
        DialogButtonHook[] hooks;
        for (DialogButtonHook element : hooks = button.getButtonHooks()) {
            element.dialogButtonCausedClose(button);
        }
    }

    public boolean wasClosedByCommit() {
        return this.wasClosedBy(this.getCommitButton());
    }

    private DialogButton getButtonBy(DialogButtonType type) {
        return this.buttonManager.getButtonBy(type);
    }

    public boolean wasClosedByCancel() {
        return this.wasClosedBy(this.getCancelButton());
    }

    public boolean wasClosedBy(DialogButton button) {
        if (button != null) {
            return button.equals(this.wasClosedBy());
        }
        return false;
    }

    public DialogButton wasClosedBy() {
        return this.wasClosedBy;
    }

    public void setNonCollapsable() {
        this.nonCollapsable = true;
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setAppropriateLocation() {
        this.dialog.setLocation(GUITools.calculateWindowStackLocation(this.getWindowStack(), this.dialog));
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        DialogButton requiredButton = this.buttonManager.getRequiredButton();
        if (requiredButton != null && this.pressButton(requiredButton)) {
            this.closeDialog(requiredButton);
            return;
        }
        this.dialog.dispose();
    }

    private boolean pressButton(DialogButton button) {
        if (button != null && button.isEnabled()) {
            return button.performButtonAction();
        }
        return false;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public boolean hasButtons() {
        return this.buttonManager.hasButtons();
    }

    public void removeAllButtons() {
        this.buttonManager.removeAll();
    }
}

