/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog;

import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.SwingInternalSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.gui.dialog.button.DialogButtonType;
import com.schneide.base.gui.dialog.button.HandledDialogButton;
import com.schneide.base.gui.dialog.button.NonvalidatingDialogButton;
import com.schneide.base.gui.dialog.button.ValidatingDialogButton;
import com.schneide.base.gui.i18n.DirectDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.system.Base;

public class DialogButtonAdder {
    private final SwingInternalSchneideDialog<?> internalDialog;
    private final AbstractSchneideDialog<?> dialog;
    private final I18NKey i18n;

    public <ANSWER> DialogButtonAdder(AbstractSchneideDialog<ANSWER> dialog, SwingInternalSchneideDialog<ANSWER> internalDialog, I18NKey i18n) {
        this.dialog = dialog;
        this.internalDialog = internalDialog;
        this.i18n = i18n;
    }

    private void button(DialogButton button, DialogButtonType type) {
        this.internalDialog.addButton(button, type);
    }

    public void button(DialogButton button) {
        this.button(button, DialogButtonType.OPTIONAL_BUTTON);
    }

    public DialogButton button(String buttonText, String tooltipText, DialogButtonHandler handler) {
        HandledDialogButton button = new HandledDialogButton(buttonText, tooltipText, handler);
        this.button(button);
        return button;
    }

    public void withFirstCommitAndLastCancel(DialogButton[] buttons) throws IllegalArgumentException {
        if (buttons.length > 1) {
            this.commitButton(buttons[0]);
            for (int i = 1; i < buttons.length - 1; ++i) {
                this.button(buttons[i]);
            }
        } else {
            throw new IllegalArgumentException("DialogButton-Array zu klein (muss 2 oder mehr Elemente enthalten).");
        }
        this.cancelButton(buttons[buttons.length - 1]);
    }

    public void closeButton() {
        this.button(new NonvalidatingDialogButton(new DirectDisplayInformation(this.getI18NEntryIfPresent(this.i18n.withKeyPart("button.close.title"), AbstractSchneideDialog.getDefaultCloseButtonTitle()), this.getI18NEntryIfPresent(this.i18n.withKeyPart("button.close.tooltip"), ""))), DialogButtonType.CLOSE_BUTTON);
    }

    public void cancelButton() {
        this.cancelButton(this.getI18NEntryIfPresent(this.i18n.withKeyPart("button.cancel.title"), SwingInternalSchneideDialog.getDefaultCancelButtonTitle()), this.getI18NEntryIfPresent(this.i18n.withKeyPart("button.cancel.tooltip"), ""));
    }

    private String getI18NEntryIfPresent(I18NKey key, String fallbackValue) {
        String result = fallbackValue;
        if (Base.getTextContent().hasTextFor(key.getKey())) {
            result = key.resolvedText();
        }
        return result;
    }

    public void cancelButton(DialogButton cancelButton) {
        this.button(cancelButton, DialogButtonType.CANCEL_BUTTON);
    }

    public void cancelButton(String cancellationText, String tooltipText) {
        this.cancelButton(new NonvalidatingDialogButton(new DirectDisplayInformation(cancellationText, tooltipText)));
    }

    public void cancelButton(DisplayInformation displayInformation) {
        this.cancelButton(displayInformation.getTitle(), displayInformation.getTooltip());
    }

    private DialogButton commitButton(String fallbackTitle) {
        return this.commitButton(this.getI18NEntryIfPresent(this.i18n.withKeyPart("button.commit.title"), fallbackTitle), this.getI18NEntryIfPresent(this.i18n.withKeyPart("button.commit.tooltip"), ""));
    }

    public DialogButton commitButton(I18NResolvable title) {
        return this.commitButton(title.resolvedText(), "");
    }

    public DialogButton commitButton(DialogButton commitButton) {
        this.button(commitButton, DialogButtonType.COMMIT_BUTTON);
        return commitButton;
    }

    public DialogButton commitButton(String commitmentText, String tooltipText) {
        return this.commitButton(new ValidatingDialogButton((DisplayInformation)new DirectDisplayInformation(commitmentText, tooltipText), this.dialog));
    }

    public DialogButton commitButton(DisplayInformation displayInformation) {
        return this.commitButton(displayInformation.getTitle(), displayInformation.getTooltip());
    }

    public void commitCancelButtons() {
        this.commitButton(SwingInternalSchneideDialog.getDefaultCommitButtonTitle());
        this.cancelButton();
    }

    public void commitCancelButtons(String commit, String cancel) {
        this.commitButton(commit, "");
        this.cancelButton(cancel, "");
    }

    public void commitCancelButtons(I18NResolvable commitTitle, I18NResolvable cancelTitle) {
        this.commitCancelButtons(commitTitle.resolvedText(), cancelTitle.resolvedText());
    }
}

