/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.component.CellContext;
import com.schneide.base.gui.component.CellRendererLabel;
import com.schneide.base.gui.data.bindings.CellEditedListener;
import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public final class StringEditorRenderer<ELEMENT>
extends AbstractAsynchronousRenderer<String>
implements CellEditorListener {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Base.getLogger(this);
    private final CellEditedListener<ELEMENT, String> editorListener;
    private DataResult<ELEMENT, String> editedValue;
    private boolean isEditable;
    private final JTextField editor;

    public StringEditorRenderer(CellEditedListener<ELEMENT, String> editorListener) {
        this.editorListener = editorListener;
        this.isEditable = false;
        this.editor = new JTextField();
        this.addCellEditorListener(this);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return this.isDoubleClick(e);
        }
        return this.isEditable;
    }

    @Override
    public String renderAsText(String value) {
        return value;
    }

    @Override
    protected void configureColors(JComponent component, CellContext cellContext, boolean isSelected, boolean hasFocus) {
        if (isSelected && hasFocus) {
            component.setBackground(Color.WHITE);
            component.setForeground(Color.BLACK);
            return;
        }
        super.configureColors(component, cellContext, isSelected, hasFocus);
    }

    @Override
    protected JComponent getEditorComponent(DataResult<?, String> value, boolean isSelected, int row) {
        this.editedValue = value;
        return this.editorForCurrentValue();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getCurrentEditorValue();
    }

    @Override
    protected JComponent getComponentFor(String value) {
        return new CellRendererLabel(value);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.setEditable(false);
        this.editorListener.valueChanged(this.editedValue.getElement(), this.getCurrentEditorValue());
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.setEditable(false);
    }

    private boolean isDoubleClick(EventObject e) {
        MouseEvent me = (MouseEvent)e;
        return me.getClickCount() >= 2;
    }

    private JTextField editorForCurrentValue() {
        this.editor.setText(this.textOfCurrentValue());
        return this.editor;
    }

    private String textOfCurrentValue() {
        try {
            return this.editedValue.getValue();
        }
        catch (Exception e) {
            this.logger.error("Could not get value of DataResult.", e);
            return "";
        }
    }

    private String getCurrentEditorValue() {
        return this.editor.getText();
    }

    private void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
}

