/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.component.CellRendererLabel;
import com.schneide.base.gui.component.table.TableColorProviderFactory;
import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.i18n.EmptyText;
import com.schneide.base.i18n.model.I18NResolvable;
import java.text.DecimalFormat;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.swing.JComponent;
import org.jscience.physics.amount.Amount;

public class QuantityRenderer<QUANTITY extends Quantity>
extends AbstractAsynchronousRenderer<Amount<QUANTITY>> {
    private static final long serialVersionUID = 3199008865274490863L;
    private final Unit<QUANTITY> unit;
    private final I18NResolvable failureText;
    private final DecimalFormat format;

    public QuantityRenderer(Unit<QUANTITY> unit) {
        this(unit, new DecimalFormat());
    }

    public QuantityRenderer(Unit<QUANTITY> unit, DecimalFormat format) {
        this(unit, format, new EmptyText());
    }

    public QuantityRenderer(Unit<QUANTITY> unit, DecimalFormat format, I18NResolvable failureText) {
        this(unit, format, failureText, new TableColorProviderFactory());
    }

    public QuantityRenderer(Unit<QUANTITY> unit, DecimalFormat format, I18NResolvable failureText, TableColorProviderFactory<DataResult<?, Amount<QUANTITY>>> newFactory) {
        super(newFactory);
        this.unit = unit;
        this.format = format;
        this.failureText = failureText;
    }

    @Override
    protected JComponent getComponentFor(Amount<QUANTITY> value) {
        return new CellRendererLabel(this.renderAsText(value));
    }

    private String getFormattedValue(Amount<QUANTITY> value) {
        return this.format.format(value.doubleValue(this.unit));
    }

    @Override
    public String renderAsText(Amount<QUANTITY> value) {
        if (null == value) {
            return this.failureText.resolvedText();
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getFormattedValue(value));
        result.append(" ");
        result.append(this.unit.toString());
        return result.toString();
    }
}

