/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.bindings.DenotableIdentifier;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.gui.data.renderer.MultipleSelectionChangeListener;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class MultipleBooleanRenderer<ELEMENT, ID extends DenotableIdentifier>
extends AbstractAsynchronousRenderer<Map<ID, Boolean>> {
    private static final long serialVersionUID = 1L;
    private DataResult<ELEMENT, Map<ID, Boolean>> dataResult;
    private final MultipleSelectionChangeListener<ELEMENT, ID> listener;
    private final Iterable<ID> identifiers;
    private final Map<ID, JCheckBox> editors;
    private JComponent editorPanel;

    public MultipleBooleanRenderer(MultipleSelectionChangeListener<ELEMENT, ID> initialListener, Iterable<ID> identifiers) {
        this.listener = initialListener;
        this.identifiers = identifiers;
        this.editors = new HashMap<ID, JCheckBox>();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.dataResult = (DataResult)value;
        this.fireEditingStopped();
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private JCheckBox createEditor(ID id) {
        JCheckBox editor = new JCheckBox();
        editor.setOpaque(true);
        editor.addActionListener(e -> {
            if (null == this.listener) {
                return;
            }
            ELEMENT currentElement = this.dataResult.getElement();
            this.listener.userChangedValueFor(currentElement, -1, (DenotableIdentifier)id, this.editors.get(id).isSelected());
        });
        return editor;
    }

    private JComponent createEditorPanel() {
        JPanel panel = new JPanel();
        for (DenotableIdentifier id : this.identifiers) {
            JCheckBox editor = this.createEditor(id);
            panel.add(editor);
            panel.add(new JLabel(id.getDenotation()));
            this.editors.put(id, editor);
        }
        return panel;
    }

    @Override
    protected JComponent getComponentFor(Map<ID, Boolean> valueMap) {
        this.editorPanel = this.createEditorPanel();
        for (DenotableIdentifier id : this.identifiers) {
            this.editors.get(id).setSelected(valueMap.get(id));
        }
        return this.editorPanel;
    }

    public Dimension getPreferredSize() {
        if (this.editors.isEmpty()) {
            return new Dimension();
        }
        return this.editorPanel.getPreferredSize();
    }

    @Override
    public String renderAsText(Map<ID, Boolean> value) {
        return "";
    }
}

