/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.bindings;

import com.schneide.base.gui.data.bindings.BindingTableModel;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.table.TableRowSorter;

public class BindingTableRowSorter<DATA>
extends TableRowSorter<BindingTableModel<DATA>> {
    private final List<TableColumnBinding<DATA, String>> bindingList;

    public BindingTableRowSorter(BindingTableModel<DATA> model, List<TableColumnBinding<DATA, String>> bindingList) {
        super(model);
        this.bindingList = bindingList;
        this.setSortsOnUpdates(true);
    }

    @Override
    protected boolean useToString(int column) {
        return false;
    }

    @Override
    public Comparator<?> getComparator(int column) {
        if (this.isSortable(column)) {
            return this.bindingList.get(column).getComparator();
        }
        return super.getComparator(column);
    }

    @Override
    public void setSortable(int column, boolean sortable) {
        throw new UnsupportedOperationException("Setting of sortable state is not allowed");
    }

    @Override
    public boolean isSortable(int column) {
        return this.bindingList.get(column).isSortable();
    }

    @Override
    public void setComparator(int column, Comparator<?> comparator) {
        throw new UnsupportedOperationException("Setting of comparator is not allowed");
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        this.checkSortKeys(sortKeys);
        super.setSortKeys(sortKeys);
    }

    protected void checkSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        for (RowSorter.SortKey sortKey : sortKeys) {
            if (this.getBindingForColumn(sortKey.getColumn()).isSortable()) continue;
            throw new IllegalArgumentException("Sort key for non-sortable column '" + sortKey.getColumn() + "' given!");
        }
    }

    protected TableColumnBinding<DATA, String> getBindingForColumn(int column) {
        if (column >= this.bindingList.size()) {
            throw new IllegalArgumentException("Invalid column " + column + " given!");
        }
        return this.bindingList.get(column);
    }
}

