/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.bindings;

import com.schneide.base.datatypes.Cache;
import com.schneide.base.gui.data.bindings.ColumnValueChangeListener;
import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import com.schneide.base.gui.data.value.ListChangeListener;
import com.schneide.base.gui.data.value.ListValue;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.logging.Logger;
import com.schneide.base.logging.implementation.Log4jSchneideLogger;
import com.schneide.base.system.Base;
import com.schneide.base.util.EqualsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;

public final class BindingTableModel<E>
extends AbstractTableModel
implements ColumnValueChangeListener<E>,
ListChangeListener<E> {
    private static final long serialVersionUID = -3283894075562656472L;
    private final List<TableColumnBinding<E, ?>> columnBindings;
    private final transient ListValue<E> listValue;
    private final Cache<ValueKey<E>, BoundDataResult<E, ?>> dataResults;

    public BindingTableModel(ListValue<E> listValue, Iterable<TableColumnBinding<E, ?>> columnBindings) {
        this.listValue = listValue;
        this.columnBindings = new ArrayList();
        for (TableColumnBinding<E, ?> binding : columnBindings) {
            this.columnBindings.add(binding);
        }
        this.dataResults = new Cache<ValueKey<E>, BoundDataResult<E, ?>>(){
            private static final long serialVersionUID = -7741536235968344960L;

            @Override
            public BoundDataResult<E, ?> createInstanceFor(ValueKey<E> key) {
                return new BoundDataResult(key.getColumnBinding(), BindingTableModel.this, key.getElement(), key.getColumnBinding().isLongRunning());
            }
        };
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnBindings.get(columnIndex).isEditable();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnBindings.get(column).getColumnName();
    }

    protected <V> int getColumnIndexOf(TableColumnBinding<E, V> binding) {
        return this.columnBindings.indexOf(binding);
    }

    protected int getRowIndexOf(E element) {
        return this.listValue.indexOf(element);
    }

    @Override
    public int getColumnCount() {
        return this.columnBindings.size();
    }

    @Override
    public int getRowCount() {
        return this.listValue.getSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataResults.getInstanceFor(this.getCacheKeyFor((E)rowIndex, columnIndex));
    }

    private ValueKey<E> getCacheKeyFor(int rowIndex, int columnIndex) {
        return this.getCacheKeyFor(this.listValue.getElementAt(rowIndex), columnIndex);
    }

    private ValueKey<E> getCacheKeyFor(E element, int columnIndex) {
        return new ValueKey<E>(element, this.columnBindings.get(columnIndex));
    }

    @Override
    public <V> void columnValueChanged(TableColumnBinding<E, V> binding, E element) {
        int row = this.getRowIndexOf(element);
        int column = this.getColumnIndexOf(binding);
        if (this.isInvalid(row) || this.isInvalid(column)) {
            return;
        }
        this.dataResults.clearCacheFor(this.getCacheKeyFor((E)row, column));
        EDT.perform(() -> this.fireTableCellUpdated(row, column));
    }

    private boolean isInvalid(int index) {
        return -1 == index;
    }

    @Override
    public void elementAdded(E element, int index) {
        EDT.perform(() -> this.fireTableRowsInserted(index, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void elementRemoved(E element, int index) {
        BindingTableModel bindingTableModel = this;
        synchronized (bindingTableModel) {
            EDT.perform(() -> {
                this.clearCacheForElement(element);
                if (index == -1) {
                    Log4jSchneideLogger.getLogger(this).warn("Invalid element index " + index);
                    return;
                }
                this.fireTableDataChanged();
            });
        }
    }

    @Override
    public void elementUpdated(E element, int index) {
        EDT.perform(() -> {
            this.clearCacheForElement(element);
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        });
    }

    @Override
    public void elementsReplaced() {
        EDT.perform(() -> {
            this.dataResults.clearCache();
            this.fireTableDataChanged();
        });
    }

    private void clearCacheForElement(E element) {
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.dataResults.clearCacheFor(this.getCacheKeyFor(element, column));
        }
    }

    private static class ValueKey<E>
    implements EqualsBuilder.EqualComparable {
        private final E element;
        private final TableColumnBinding<E, ?> columnBinding;

        public ValueKey(E element, TableColumnBinding<E, ?> columnBinding) {
            this.element = element;
            this.columnBinding = columnBinding;
        }

        public TableColumnBinding<E, ?> getColumnBinding() {
            return this.columnBinding;
        }

        public E getElement() {
            return this.element;
        }

        public Iterable<Object> getValuesToCompare() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.element);
            result.add(this.columnBinding);
            return result;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.isEqual(this, obj);
        }

        public int hashCode() {
            return EqualsBuilder.hashCodeFor(this);
        }

        public String toString() {
            return String.valueOf(this.element) + ":" + String.valueOf(this.columnBinding.getClass());
        }
    }

    private static class BoundDataResult<E, V>
    extends SwingWorker<V, Void>
    implements DataResult<E, V> {
        private final TableColumnBinding<E, V> tableColumnBinding;
        private final E element;
        private final BindingTableModel<E> tableModel;
        private final boolean loadAsynchronously;

        public BoundDataResult(TableColumnBinding<E, V> tableColumnBinding, BindingTableModel<E> tableModel, E element, boolean loadAsynchronously) {
            this.tableColumnBinding = tableColumnBinding;
            this.tableModel = tableModel;
            this.element = element;
            this.loadAsynchronously = loadAsynchronously;
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public boolean hasLoaded() {
            return !this.loadAsynchronously || this.isDone();
        }

        @Override
        public V getValue() throws Exception {
            if (!this.loadAsynchronously) {
                return this.retrieveValue();
            }
            try {
                return (V)this.get();
            }
            catch (InterruptedException e) {
                this.getLogger().debug("Asynchronous load interrupted.", e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.getLogger().error("Error while loading data", e);
            }
            throw new Exception("Error while loading value");
        }

        @Override
        protected void done() {
            super.done();
            this.tableModel.fireTableCellUpdated(this.tableModel.getRowIndexOf(this.element), this.tableModel.getColumnIndexOf(this.tableColumnBinding));
        }

        private Logger getLogger() {
            return Base.getLogger(this);
        }

        protected V retrieveValue() {
            return this.tableColumnBinding.getValueFor(this.element, this.tableModel.getRowIndexOf(this.element));
        }

        @Override
        protected final V doInBackground() throws Exception {
            return this.retrieveValue();
        }
    }
}

