/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component.table;

import com.schneide.base.gui.component.table.DropTargetColorProvider;
import com.schneide.base.gui.component.table.EditableColorProvider;
import com.schneide.base.gui.component.table.NormalColorProvider;
import com.schneide.base.gui.component.table.SelectedColorProvider;
import com.schneide.base.gui.component.table.TableCellRendererColorProvider;
import java.awt.Color;
import javax.swing.JTable;

public class TableColorProviderFactory<DATA> {
    private static final Color DEFAULT_ALTERNATE_BACKGROUND = new Color(240, 240, 240);
    private final Color alternateBackground;

    public TableColorProviderFactory() {
        this(DEFAULT_ALTERNATE_BACKGROUND);
    }

    public TableColorProviderFactory(Color alternateBackground) {
        this.alternateBackground = alternateBackground;
    }

    public TableCellRendererColorProvider getColorProvider(JTable table, DATA value, boolean isSelected, int row, int column) {
        if (this.isDropTarget(table, row, column)) {
            return this.getDropTargetColorProvider(table, value, this.isAlternateRow(row));
        }
        if (isSelected) {
            return this.getSelectedColorProvider(table, value, this.isAlternateRow(row));
        }
        if (table.isCellEditable(row, column)) {
            return this.getEditableColorProvider(table, value, this.isAlternateRow(row));
        }
        return this.getNormalColorProvider(table, value, this.isAlternateRow(row));
    }

    protected boolean isAlternateRow(int row) {
        return row % 2 == 0;
    }

    public TableCellRendererColorProvider getNormalColorProvider(JTable table, DATA value, boolean isAlternateRow) {
        return new NormalColorProvider(table, this.alternateBackground, isAlternateRow);
    }

    protected TableCellRendererColorProvider getEditableColorProvider(JTable table, DATA value, boolean isAlternateRow) {
        return new EditableColorProvider(table, this.alternateBackground, isAlternateRow);
    }

    protected TableCellRendererColorProvider getSelectedColorProvider(JTable table, DATA value, boolean isAlternateRow) {
        return new SelectedColorProvider(table);
    }

    protected TableCellRendererColorProvider getDropTargetColorProvider(JTable table, DATA value, boolean isAlternateRow) {
        return new DropTargetColorProvider(table);
    }

    private boolean isDropTarget(JTable table, int row, int column) {
        JTable.DropLocation dropLocation = table.getDropLocation();
        return dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && this.isLocationMatching(dropLocation, row, column);
    }

    private boolean isLocationMatching(JTable.DropLocation dropLocation, int row, int column) {
        return dropLocation.getRow() == row && dropLocation.getColumn() == column;
    }
}

