/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component;

import com.schneide.base.gui.component.CellContext;
import com.schneide.base.gui.component.table.TableColorProviderFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractTableCellEditorRenderer<C extends JComponent, DATA>
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private static final long serialVersionUID = -5611998063230305051L;
    private final TableColorProviderFactory<DATA> colorProviderFactory;

    protected AbstractTableCellEditorRenderer() {
        this(new TableColorProviderFactory());
    }

    protected AbstractTableCellEditorRenderer(TableColorProviderFactory<DATA> colorProviderFactory) {
        this.colorProviderFactory = colorProviderFactory;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        C component = this.getComponent(value);
        CellContext context = new CellContext(table, value, row, column);
        this.configureComponent((JComponent)component, context, isSelected, hasFocus);
        return component;
    }

    protected <COMPONENT extends JComponent> void configureComponent(COMPONENT component, CellContext cellContext, boolean isSelected, boolean hasFocus) {
        this.configureComponent(component, cellContext, isSelected, hasFocus, true);
    }

    protected <COMPONENT extends JComponent> void configureComponent(COMPONENT component, CellContext cellContext, boolean isSelected, boolean hasFocus, boolean doChildren) {
        this.configureColors(component, cellContext, isSelected, hasFocus);
        this.configureFont(component, cellContext, isSelected, hasFocus);
        component.setBorder(this.getBorder(hasFocus, isSelected));
        if (doChildren) {
            for (JComponent child : this.getChildrenOf(component)) {
                this.configureColors(child, cellContext, isSelected, hasFocus);
                this.configureFont(child, cellContext, isSelected, hasFocus);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent result = this.getEditorComponent(value, isSelected, row);
        if (null == result) {
            result = (JComponent)this.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
        }
        result.setOpaque(true);
        CellContext context = new CellContext(table, value, row, column);
        this.configureComponent(result, context, true, true);
        return result;
    }

    protected JComponent getEditorComponent(DATA value, boolean isSelected, int row) {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    private JComponent[] getChildrenOf(JComponent component) {
        Component[] components = component.getComponents();
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        for (Component child : components) {
            result.add((JComponent)child);
        }
        return result.toArray(new JComponent[result.size()]);
    }

    protected void configureFont(JComponent component, CellContext cellContext, boolean isSelected, boolean hasFocus) {
        component.setFont(cellContext.getTable().getFont());
    }

    protected void configureColors(JComponent component, CellContext cellContext, boolean isSelected, boolean hasFocus) {
        component.setForeground(this.getColorProviderFactory().getColorProvider(cellContext.getTable(), cellContext.getValue(), isSelected, cellContext.getRow(), cellContext.getColumn()).getForeground());
        component.setBackground(this.getColorProviderFactory().getColorProvider(cellContext.getTable(), cellContext.getValue(), isSelected, cellContext.getRow(), cellContext.getColumn()).getBackground());
    }

    protected TableColorProviderFactory<DATA> getColorProviderFactory() {
        return this.colorProviderFactory;
    }

    protected abstract C getComponent(DATA var1);

    protected Border getBorder(boolean hasFocus, boolean isSelected) {
        if (hasFocus && isSelected) {
            if (null == this.getFocusSelectedHighlightBorder()) {
                return UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            return this.getFocusSelectedHighlightBorder();
        }
        return BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    private Border getFocusSelectedHighlightBorder() {
        return UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
    }

    protected boolean isAlternateRow(int row) {
        return row % 2 == 0;
    }
}

