/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.color;

import java.awt.Color;

public final class ColorUtil {
    private static final String htmlPrefix = "#";

    private ColorUtil() {
    }

    public static String asHTMLString(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        return htmlPrefix + (String)(red.length() == 1 ? "0" + red : red) + (String)(green.length() == 1 ? "0" + green : green) + (String)(blue.length() == 1 ? "0" + blue : blue);
    }

    public static Color fromHTMLString(String colorString) throws IllegalArgumentException {
        if (!colorString.startsWith(htmlPrefix)) {
            throw new IllegalArgumentException("Given string doesn't start with #, not a valid HTML color: " + colorString);
        }
        int colorCode = Integer.parseInt(colorString.substring(1), 16);
        return new Color(colorCode);
    }
}

