/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.button;

import com.schneide.base.input.inputs.touchscreen.helper.DeriveTouchscreenFont;
import com.schneide.base.input.inputs.touchscreen.helper.TouchscreenConstants;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public interface SchneideButtonFactory {
    public JButton preparedButton();

    public JButton preparedButton(String var1);

    public JButton preparedButton(Action var1);

    public JButton preparedButton(Icon var1);

    public JButton preparedButton(String var1, Icon var2);

    public Font getButtonFontFor(JButton var1);

    public Border getButtonBorderFor(JButton var1);

    public void applyTouchscreenSettingsTo(JButton ... var1);

    public static class TouchscreenButtonFactory
    extends AbstractButtonFactory {
        @Override
        public JButton preparedButton() {
            return this.preparedButton(null, null);
        }

        @Override
        public JButton preparedButton(String text) {
            return this.preparedButton(text, null);
        }

        @Override
        public JButton preparedButton(Icon icon) {
            return this.preparedButton(null, icon);
        }

        @Override
        public JButton preparedButton(String text, Icon icon) {
            JButton result = new JButton(text, icon);
            this.applyTouchscreenSettingsTo(result);
            return result;
        }

        @Override
        public JButton preparedButton(Action action) {
            JButton result = new JButton(action);
            this.applyTouchscreenSettingsTo(result);
            return result;
        }

        @Override
        public Font getButtonFontFor(JButton button) {
            return DeriveTouchscreenFont.from(button.getFont());
        }

        @Override
        public Border getButtonBorderFor(JButton button) {
            return BorderFactory.createCompoundBorder(button.getBorder(), TouchscreenConstants.EMPTY_BORDER);
        }
    }

    public static class DesktopButtonFactory
    extends AbstractButtonFactory {
        @Override
        public JButton preparedButton() {
            return new JButton();
        }

        @Override
        public JButton preparedButton(String text) {
            return new JButton(text);
        }

        @Override
        public JButton preparedButton(Action action) {
            return new JButton(action);
        }

        @Override
        public JButton preparedButton(Icon icon) {
            return new JButton(icon);
        }

        @Override
        public JButton preparedButton(String text, Icon icon) {
            return new JButton(text, icon);
        }

        @Override
        public Font getButtonFontFor(JButton button) {
            return button.getFont();
        }

        @Override
        public Border getButtonBorderFor(JButton button) {
            return button.getBorder();
        }
    }

    public static abstract class AbstractButtonFactory
    implements SchneideButtonFactory {
        @Override
        public void applyTouchscreenSettingsTo(JButton ... buttons) {
            for (JButton button : buttons) {
                this.applySettingsTo(button);
            }
        }

        private void applySettingsTo(JButton button) {
            if (null == button) {
                return;
            }
            button.setBorder(this.getButtonBorderFor(button));
            button.setFont(this.getButtonFontFor(button));
        }
    }
}

