/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.StringUtil;
import com.schneide.base.threading.ThreadMutex;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class LookAndFeelManager
extends LoggedObject {
    private static final String COULD_NOT_BE_LOADED = "' konnte nicht geladen werden.";
    private final ThreadMutex callerLock = new ThreadMutex();

    protected static void switchTo(String className) {
        new LookAndFeelManager().setLookAndFeel(className);
    }

    public void setLookAndFeel(String classname) {
        this.setLookAndFeel(classname, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookAndFeel(String classname, String themeClassname) {
        ThreadMutex threadMutex = this.callerLock;
        synchronized (threadMutex) {
            this.switchToLookAndFeel(classname, themeClassname);
        }
    }

    protected void switchToLookAndFeel(String classname, String themeClassname) {
        this.installLookAndFeel(classname);
        LookAndFeel actualLookAndFeel = UIManager.getLookAndFeel();
        this.getLogger().info("Verwendetes LookAndFeel: " + actualLookAndFeel.getName());
        this.installTheme(themeClassname, actualLookAndFeel);
        this.installLookAndFeel(classname);
    }

    protected void installTheme(String themeClassname, LookAndFeel actualLookAndFeel) {
        if (StringUtil.isEmptyOrNull(themeClassname)) {
            return;
        }
        String themeName = "";
        this.getLogger().info("Verwendetes Farbschema: ");
    }

    protected void installLookAndFeel(String classname) {
        try {
            UIManager.setLookAndFeel(classname);
        }
        catch (Exception e) {
            this.getLogger().error("Das angegebene Look&Feel '" + classname + COULD_NOT_BE_LOADED, e);
        }
    }
}

