/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import com.schneide.base.gui.FilenameAdjuster;
import com.schneide.base.i18n.model.I18NResolvable;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter
implements FilenameAdjuster {
    private final String extension;
    private final I18NResolvable description;

    public ExtensionFileFilter(String extension, I18NResolvable description) {
        this.extension = extension;
        this.description = description;
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() || file.getName().toUpperCase().endsWith(this.extension.toUpperCase());
    }

    @Override
    public String getDescription() {
        return this.description.resolvedText();
    }

    @Override
    public String adjust(String filename) {
        if (filename.endsWith(this.extension)) {
            return filename;
        }
        return filename + this.extension;
    }
}

