/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.general;

import com.schneide.base.functional.Command;

public class RepeatEvery {
    private final int iterationCount;
    private final Command action;
    private int iterations;
    private int current;

    private RepeatEvery(int iterationCount, Command action) {
        this.iterationCount = iterationCount;
        this.iterations = 0;
        this.action = action;
    }

    public static RepeatEvery times(int iterationCount, Command action) {
        return new RepeatEvery(iterationCount, action);
    }

    public int iterationMaximum() {
        return this.iterationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int current() {
        Command command = this.action;
        synchronized (command) {
            return this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int times() {
        Command command = this.action;
        synchronized (command) {
            return this.iterations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Command command = this.action;
        synchronized (command) {
            ++this.current;
            if (0 == this.current % this.iterationCount) {
                this.current = 0;
                ++this.iterations;
                this.action.perform();
            }
        }
    }

    public int totalTicks() {
        return this.iterationMaximum() * this.times() + this.current();
    }
}

