/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.general;

import java.util.function.Supplier;

public class EvaluateEvery<T> {
    private final int iterationCount;
    private final Supplier<T> action;
    private final T defaultResult;
    private int current;

    private EvaluateEvery(int iterationCount, T defaultResult, Supplier<T> action) {
        this.iterationCount = iterationCount;
        this.defaultResult = defaultResult;
        this.action = action;
    }

    public static <T> EvaluateEvery<T> times(int iterationCount, T defaultResult, Supplier<T> action) {
        return new EvaluateEvery<T>(iterationCount, defaultResult, action);
    }

    public int iterationMaximum() {
        return this.iterationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int current() {
        Supplier<T> supplier = this.action;
        synchronized (supplier) {
            return this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T tick() {
        Supplier<T> supplier = this.action;
        synchronized (supplier) {
            ++this.current;
            if (0 == this.current % this.iterationCount) {
                this.current = 0;
                return this.action.get();
            }
            return this.defaultResult;
        }
    }
}

