/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.functional;

import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public final class WaitWith<T>
extends LoggedObject {
    private final List<Consumer<T>> actions = new ArrayList<Consumer<T>>();

    public WaitWith(Consumer<T> firstAction) {
        this.actions.add(firstAction);
    }

    public static <T> WaitWith<T> action(Consumer<T> first) {
        return new WaitWith<T>(first);
    }

    public WaitWith<T> and(Consumer<T> additional) {
        this.actions.add(additional);
        return this;
    }

    public void asynchronouslyOn(Future<T> future) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(() -> {
            try {
                Object result = future.get();
                for (Consumer consumer : this.actions) {
                    consumer.accept(result);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Cannot perform subsequent actions because an action failed.", e);
            }
        });
        service.shutdown();
    }
}

