/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.util.indicator;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.eventbus.util.indicator.Indicator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class NewsBasedIndicatorOf<N extends News, PAYLOAD>
implements Indicator<PAYLOAD> {
    private final Subscriber<N> subscriber;
    private Optional<N> caught;
    private final Predicate<N> filter;
    private Supplier<PAYLOAD> payload;

    public NewsBasedIndicatorOf(Class<N> type, EventBus applicationBus, Supplier<PAYLOAD> payload) {
        this(type, applicationBus, n -> true, payload);
    }

    public NewsBasedIndicatorOf(Class<N> type, EventBus applicationBus, Predicate<N> filter, Supplier<PAYLOAD> payload) {
        this.filter = filter;
        this.payload = payload;
        this.caught = Optional.empty();
        this.subscriber = new Subscriber<News>(type, this::catching);
        Subscriber.attach(this.subscriber, applicationBus);
    }

    private void catching(N news) {
        if (!this.filter.test(news)) {
            return;
        }
        if (this.caught.isEmpty()) {
            this.caught = Optional.ofNullable(news);
        }
        this.stop();
    }

    public void stop() {
        this.subscriber.stop();
    }

    @Override
    public Optional<PAYLOAD> currentState() {
        if (this.getCatch().isPresent()) {
            return Optional.ofNullable(this.payload.get());
        }
        return Optional.empty();
    }

    public Optional<N> getCatch() {
        return this.caught;
    }

    @Override
    public void disconnect() {
        this.stop();
    }
}

