/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.internal.subscription;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.internal.subscription.StrongSubscribedNewsReceiver;
import com.schneide.base.eventbus.internal.subscription.SubscribedNewsReceiver;
import com.schneide.base.eventbus.internal.subscription.WeakSubscribedNewsReceiver;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SubscriptionRepository
extends LoggedObject {
    private final Map<Class<? extends News>, List<SubscribedNewsReceiver<? extends News>>> registrations = new HashMap<Class<? extends News>, List<SubscribedNewsReceiver<? extends News>>>();

    public <T extends News> void subscribe(NewsReceiver<T> listener, Class<T> type) {
        this.subscribeInternal(new StrongSubscribedNewsReceiver<T>(listener), type);
    }

    public <T extends News> void subscribeWeak(NewsReceiver<T> listener, Class<T> type) {
        this.subscribeInternal(new WeakSubscribedNewsReceiver<T>(listener), type);
    }

    private <T extends News> void subscribeInternal(SubscribedNewsReceiver<T> listener, Class<T> type) {
        if (!this.registrations.containsKey(type)) {
            this.registrations.put(type, new ArrayList());
        }
        this.registrations.get(type).add(listener);
    }

    public <T extends News> void unsubscribe(NewsReceiver<T> listener) {
        for (List<SubscribedNewsReceiver<? extends News>> listeners : this.registrations.values()) {
            Iterator<SubscribedNewsReceiver<? extends News>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                SubscribedNewsReceiver<? extends News> current = iterator.next();
                current.get().filter(l -> listener == l).ifPresent(l -> iterator.remove());
            }
        }
    }

    public Iterable<NewsReceiver<?>> subscribersOf(Class<? extends News> type) {
        if (!this.registrations.containsKey(type)) {
            return new EmptyIterable();
        }
        List<SubscribedNewsReceiver<? extends News>> listeners = this.registrations.get(type);
        ArrayList result = new ArrayList();
        Iterator<SubscribedNewsReceiver<? extends News>> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            SubscribedNewsReceiver<? extends News> current = iterator.next();
            if (!current.get().isPresent()) {
                iterator.remove();
                break;
            }
            current.get().ifPresent(result::add);
        }
        return result;
    }

    public Iterable<NewsReceiver<? extends News>> getRegisteredListeners() {
        return this.receiversOutOf(this.subscribedReceivers());
    }

    private Iterable<NewsReceiver<? extends News>> receiversOutOf(List<SubscribedNewsReceiver<? extends News>> subscriptions) {
        ArrayList<NewsReceiver<? extends News>> result = new ArrayList<NewsReceiver<? extends News>>();
        for (SubscribedNewsReceiver<? extends News> each : subscriptions) {
            each.get().ifPresent(result::add);
        }
        return result;
    }

    private List<SubscribedNewsReceiver<? extends News>> subscribedReceivers() {
        ArrayList<SubscribedNewsReceiver<? extends News>> result = new ArrayList<SubscribedNewsReceiver<? extends News>>();
        for (List<SubscribedNewsReceiver<? extends News>> listeners : this.registrations.values()) {
            result.addAll(listeners);
        }
        return result;
    }

    public Iterable<NewsReceiver<? extends News>> registeredListenersSortedByRegistration() {
        List<SubscribedNewsReceiver<? extends News>> all = this.subscribedReceivers();
        all.sort((nr0, nr1) -> Long.compare(nr0.subscriptionTimestamp(), nr1.subscriptionTimestamp()));
        return this.receiversOutOf(all);
    }
}

