/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.internal;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.internal.DeliverySupervisor;
import com.schneide.base.eventbus.internal.EventBusBase;
import com.schneide.base.eventbus.internal.supervisor.AnomalyReporter;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.transformation.StringJoin;
import com.schneide.base.threading.consumer.Processor;
import java.util.function.Supplier;

public class ThreadedEventBus
extends EventBusBase
implements LifeCycle {
    private final Processor<EventBusBase.Mailing> newsSender;
    private final StopProcedure stopper;

    public ThreadedEventBus(Supplier<Boolean> forcedLogging, Supplier<Boolean> logPublications) {
        this(new ReportRemainingListeners(), forcedLogging, logPublications);
    }

    public ThreadedEventBus(StopProcedure stopper, Supplier<Boolean> forcedLogging, Supplier<Boolean> logPublications) {
        super(forcedLogging, logPublications);
        this.stopper = stopper;
        this.newsSender = new Processor<EventBusBase.Mailing>("news", "event bus news sender", news -> this.logAndSend((EventBusBase.Mailing)news));
    }

    @Override
    protected DeliverySupervisor deliverySupervisor() {
        return new AnomalyReporter();
    }

    @Override
    public void start() {
        this.newsSender.start();
    }

    @Override
    public void stop() {
        this.newsSender.stop();
        this.getLogger().info("Event bus stopped.");
        this.stopper.stopWith(this.getRegisteredListeners());
    }

    @Override
    protected void performPublishOf(EventBusBase.Mailing event) {
        this.newsSender.append(event);
    }

    private static class ReportRemainingListeners
    extends LoggedObject
    implements StopProcedure {
        @Override
        public void stopWith(Iterable<NewsReceiver<? extends News>> registeredListeners) {
            int count = IterableUtil.getSizeFor(registeredListeners);
            this.getLogger().info("There are " + count + " registered Listeners: \n\t" + StringJoin.separatedBy(registeredListeners, ", \n\t"));
        }
    }

    public static interface StopProcedure {
        public void stopWith(Iterable<NewsReceiver<? extends News>> var1);
    }
}

