/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.internal;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.inspection.InspectableEventBus;
import com.schneide.base.eventbus.internal.DeliverySupervisor;
import com.schneide.base.eventbus.internal.subscription.SubscriptionRepository;
import com.schneide.base.eventbus.internal.supervisor.NoDeliverySupervision;
import com.schneide.base.logging.LoggedObject;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class EventBusBase
extends LoggedObject
implements EventBus,
InspectableEventBus {
    private final SubscriptionRepository subscriptions;
    private final Supplier<Boolean> logPublications;
    private final Supplier<Boolean> forcedLogging;

    public EventBusBase(Supplier<Boolean> forcedLogging, Supplier<Boolean> logPublications) {
        this.forcedLogging = forcedLogging;
        this.logPublications = logPublications;
        this.subscriptions = new SubscriptionRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends News> void subscribe(NewsReceiver<T> listener, Class<T> type) {
        SubscriptionRepository subscriptionRepository = this.subscriptions;
        synchronized (subscriptionRepository) {
            this.subscriptions.subscribe(listener, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends News> void subscribeWeak(NewsReceiver<T> listener, Class<T> type) {
        SubscriptionRepository subscriptionRepository = this.subscriptions;
        synchronized (subscriptionRepository) {
            this.subscriptions.subscribeWeak(listener, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends News> void unsubscribe(NewsReceiver<T> listener) {
        this.getLogger().debug("Unsubscribing news receiver " + String.valueOf(listener));
        SubscriptionRepository subscriptionRepository = this.subscriptions;
        synchronized (subscriptionRepository) {
            this.subscriptions.unsubscribe(listener);
        }
    }

    @Override
    public final CompletableFuture<News> publish(News event) {
        if (null == event) {
            return CompletableFuture.completedFuture(event);
        }
        Mailing mailing = new Mailing(this, event);
        this.performPublishOf(mailing);
        return mailing.receipt();
    }

    protected abstract void performPublishOf(Mailing var1);

    protected DeliverySupervisor deliverySupervisor() {
        return NoDeliverySupervision.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAs(Class<? extends News> type, Mailing mailing) {
        SubscriptionRepository subscriptionRepository = this.subscriptions;
        synchronized (subscriptionRepository) {
            for (NewsReceiver<?> each : this.subscriptions.subscribersOf(type)) {
                try {
                    DeliverySupervisor supervisor = this.deliverySupervisor();
                    supervisor.deliveryStarted(each, mailing.news());
                    each.receive(mailing.news());
                    supervisor.deliveryStopped(each, mailing.news());
                }
                catch (RuntimeException e) {
                    this.getLogger().error("Exception while notifying " + String.valueOf(each) + " of new event " + String.valueOf(mailing.news()) + " over the event bus.", e);
                }
            }
        }
    }

    protected void logAndSend(Mailing mailing) {
        if (this.isLoggingForced() || this.isLoggingEnabled() && mailing.news().isLogged()) {
            this.getLogger().debug("Publishing news (" + mailing.news().getClass().getSimpleName() + "): " + mailing.news().described());
        }
        this.justSend(mailing);
    }

    private boolean isLoggingEnabled() {
        return this.logPublications.get();
    }

    private boolean isLoggingForced() {
        return this.forcedLogging.get();
    }

    protected void justSend(Mailing mailing) {
        for (Class<?> each : this.getPossibleTypesOf(mailing.news().getClass())) {
            this.sendAs(each, mailing);
        }
        mailing.redeem();
    }

    protected Iterable<Class<?>> getPossibleTypesOf(Class<?> type) {
        if (null == type || !News.class.isAssignableFrom(type)) {
            return new EmptyIterable();
        }
        HashSet result = new HashSet();
        result.add(type);
        for (Class<?> iface : type.getInterfaces()) {
            result.add(iface);
            CollectionUtil.addAll(result, this.getPossibleTypesOf(iface));
        }
        CollectionUtil.addAll(result, this.getPossibleTypesOf(type.getSuperclass()));
        return result;
    }

    protected int subscribedListenersCount() {
        return IterableUtil.getSizeFor(this.getRegisteredListeners());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<NewsReceiver<? extends News>> getRegisteredListeners() {
        SubscriptionRepository subscriptionRepository = this.subscriptions;
        synchronized (subscriptionRepository) {
            return this.subscriptions.getRegisteredListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscriptions(Consumer<NewsReceiver<?>> action) {
        SubscriptionRepository subscriptionRepository = this.subscriptions;
        synchronized (subscriptionRepository) {
            for (NewsReceiver<? extends News> each : this.subscriptions.registeredListenersSortedByRegistration()) {
                action.accept(each);
            }
        }
    }

    @Override
    public int subscriptionCount() {
        return this.subscribedListenersCount();
    }

    protected class Mailing {
        private final News news;
        private final CompletableFuture<News> receipt;

        public Mailing(EventBusBase this$0, News news) {
            this.news = news;
            this.receipt = new CompletableFuture();
        }

        public News news() {
            return this.news;
        }

        public CompletableFuture<News> receipt() {
            return this.receipt;
        }

        public void redeem() {
            this.receipt().complete(this.news());
        }
    }
}

