/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.debug;

import com.schneide.base.system.util.Megabyte;
import com.schneide.base.system.util.MemoryInformation;
import com.schneide.base.system.util.MemoryUsage;
import com.schneide.base.threading.LoopingExecutable;
import com.schneide.base.threading.delay.GenericDelay;
import java.text.DecimalFormat;
import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public class MemoryInformationDumper
extends LoopingExecutable {
    private static final Measurable<Duration> DEFAULT_INTERVAL = Measure.valueOf((int)5, (Unit)SI.SECOND);
    private static final DecimalFormat MEMORY_FORMAT = new DecimalFormat("0.0");
    private final long delayInMilliseconds;

    public MemoryInformationDumper() {
        this(DEFAULT_INTERVAL);
    }

    public MemoryInformationDumper(Measurable<Duration> delay) {
        super("MemoryInformationDumper");
        this.delayInMilliseconds = delay.longValue(SI.MILLI((Unit)SI.SECOND));
    }

    @Override
    protected void performLeadingDelay() throws Exception {
        super.performLeadingDelay();
        GenericDelay.sleep(this.delayInMilliseconds);
    }

    @Override
    protected void executeWithinLoop() throws Exception {
        MemoryInformation memoryInformation = MemoryUsage.getCurrent();
        StringBuilder buffer = new StringBuilder();
        buffer.append("Memory usage: ");
        buffer.append(MemoryInformationDumper.getFormattedRepresentation(memoryInformation.getUsedMemory()));
        buffer.append("M of ");
        buffer.append(MemoryInformationDumper.getFormattedRepresentation(memoryInformation.getTotalMemory()));
        buffer.append("M.");
        this.getLogger().debug(buffer.toString());
    }

    private static String getFormattedRepresentation(Megabyte megabyte) {
        return MEMORY_FORMAT.format(megabyte.getValue());
    }
}

