/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static Interval getMonthsIntervalOf(DateTime month) {
        DateTime startOfMonth = TimeUtil.getStartOfMonth(month);
        return Months.months((int)1).toPeriod().toDurationFrom((ReadableInstant)startOfMonth).toIntervalFrom((ReadableInstant)startOfMonth);
    }

    public static Interval getMonthsIntervalOf(DateTime fromMonth, DateTime toMonth) {
        DateTime startOfMonth = TimeUtil.getStartOfMonth(fromMonth);
        return Months.monthsBetween((ReadableInstant)startOfMonth, (ReadableInstant)TimeUtil.getStartOfMonth(toMonth)).plus(1).toPeriod().toDurationFrom((ReadableInstant)startOfMonth).toIntervalFrom((ReadableInstant)startOfMonth);
    }

    public static DateTime getStartOfMonth(DateTime month) {
        return month.withDayOfMonth(1).withMillisOfDay(0);
    }

    public static Interval constraintIntervalToMonth(Interval limitInterval, DateTime month) {
        Interval monthInterval = TimeUtil.getMonthsIntervalOf(month);
        return TimeUtil.getIntersectionOf(limitInterval, monthInterval);
    }

    private static Interval getIntersectionOf(Interval interval1, Interval interval2) {
        return new Interval((ReadableInstant)TimeUtil.max(interval1.getStart(), interval2.getStart()), (ReadableInstant)TimeUtil.min(interval1.getEnd(), interval2.getEnd()));
    }

    private static DateTime max(DateTime t1, DateTime t2) throws IllegalArgumentException {
        TimeUtil.checkParametersForNull(t1, t2);
        if (t1.isBefore((ReadableInstant)t2)) {
            return t2;
        }
        return t1;
    }

    private static DateTime min(DateTime t1, DateTime t2) throws IllegalArgumentException {
        TimeUtil.checkParametersForNull(t1, t2);
        if (t1.isAfter((ReadableInstant)t2)) {
            return t2;
        }
        return t1;
    }

    private static void checkParametersForNull(Object ... params) {
        for (Object param : params) {
            if (null != param) continue;
            throw new IllegalArgumentException("Given parameters must not be null");
        }
    }

    public static DateTime startOfDay(DateTime day) {
        return day.withMillisOfDay(0);
    }

    public static DateTime endOfDay(DateTime day) {
        return TimeUtil.startOfDay(day).plus((ReadablePeriod)Days.ONE).minus(1L);
    }
}

