/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.timing.Clock;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SpecificallyMentionTodayDateTimeFormatter {
    private final DateTimeFormatter todayFormatter;
    private final DateTimeFormatter formatter;
    private final I18NResolvable invalidValueText;

    public SpecificallyMentionTodayDateTimeFormatter(DateTimeFormatter formatter, I18NResolvable invalidValueText) {
        this.formatter = formatter;
        this.invalidValueText = invalidValueText;
        NotI18NYet todayText = new NotI18NYet("heute", new Object[0]);
        this.todayFormatter = DateTimeFormat.forPattern((String)("'" + todayText.text() + "' HH:mm"));
    }

    public String textFor(DateTime dateTime) {
        if (!this.isValidValue(dateTime)) {
            return this.invalidValueText.resolvedText();
        }
        return this.formatterFor(dateTime).print((ReadableInstant)dateTime);
    }

    protected boolean isValidValue(DateTime dateTime) {
        return null != dateTime && dateTime.isAfter(0L);
    }

    protected DateTimeFormatter formatterFor(DateTime date) {
        if (this.isToday(date)) {
            return this.todayFormatter;
        }
        return this.formatter;
    }

    protected boolean isToday(DateTime dateTime) {
        DateTime todayAtMidnight = Clock.now().withTimeAtStartOfDay();
        DateTime tomorrowAtMidnight = todayAtMidnight.plusDays(1);
        return !dateTime.isBefore((ReadableInstant)todayAtMidnight) && dateTime.isBefore((ReadableInstant)tomorrowAtMidnight);
    }
}

