/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import java.io.Serializable;
import java.util.Comparator;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class NextToDateComparator
implements Comparator<DateTime>,
Serializable {
    private static final long serialVersionUID = -7944435587209852051L;
    private final DateTime referenceDate;

    public NextToDateComparator(DateTime referenceDate) {
        this.referenceDate = referenceDate;
    }

    @Override
    public int compare(DateTime date1, DateTime date2) {
        return this.absoluteDurationToReference(date1).compareTo((ReadableDuration)this.absoluteDurationToReference(date2));
    }

    private Duration absoluteDurationToReference(DateTime date) {
        return NextToDateComparator.absoluteDurationBetween(date, this.referenceDate);
    }

    public static Duration absoluteDurationBetween(DateTime date1, DateTime date2) {
        if (date1.isBefore((ReadableInstant)date2)) {
            return new Duration((ReadableInstant)date1, (ReadableInstant)date2);
        }
        return new Duration((ReadableInstant)date2, (ReadableInstant)date1);
    }
}

