/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.datetime.WaitFor;
import com.schneide.base.timing.Clock;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public class MinimalDelay {
    private final long milliseconds;
    private long lastTrigger;

    public MinimalDelay(long milliseconds) {
        this.milliseconds = milliseconds;
        this.lastTrigger = Long.MIN_VALUE;
    }

    public MinimalDelay(java.time.Duration delay) {
        this(delay.toMillis());
    }

    public MinimalDelay(Amount<Duration> delay) {
        this(delay.longValue(SI.MILLI((Unit)SI.SECOND)));
    }

    public static MinimalDelay of(long milliseconds) {
        return new MinimalDelay(milliseconds);
    }

    public void trigger() {
        WaitFor wait = this.getWaitRightNow();
        wait.perform();
        this.adjustTriggerToNow();
    }

    public void adjustTriggerToNow() {
        this.lastTrigger = this.getNowInMilliseconds();
    }

    protected long getNowInMilliseconds() {
        return Clock.now().getMillis();
    }

    protected boolean wasTriggeredBefore() {
        return Long.MIN_VALUE != this.lastTrigger;
    }

    public WaitFor getWaitRightNow() {
        if (!this.wasTriggeredBefore()) {
            return WaitFor.NOTHING;
        }
        long delta = this.getNowInMilliseconds() - this.lastTrigger;
        return new WaitFor(this.milliseconds - delta);
    }

    public long inMilliseconds() {
        return this.milliseconds;
    }
}

