/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.optional;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Predicate;

public final class OptionalUtil {
    private OptionalUtil() {
    }

    public static boolean anyEmpty(Iterable<Optional<?>> optionals) {
        return !OptionalUtil.allPresent(optionals);
    }

    public static boolean anyEmpty(Optional<?> ... optionals) {
        return OptionalUtil.anyEmpty(List.of(optionals));
    }

    public static boolean allPresent(Iterable<Optional<?>> optionals) {
        for (Optional<?> each : optionals) {
            if (!each.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean allPresent(Optional<?> ... optionals) {
        return OptionalUtil.allPresent(List.of(optionals));
    }

    public static OptionalDouble asDouble(Optional<Double> genericOptional) {
        if (genericOptional.isEmpty()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(genericOptional.get());
    }

    public static <T> Optional<T> findIn(Iterable<T> elements, Predicate<T> condition) {
        for (T each : elements) {
            if (!condition.test(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public static <T> Iterable<T> asIterable(Optional<T> maybe) {
        if (maybe.isEmpty()) {
            return new EmptyIterable();
        }
        return List.of(maybe.get());
    }
}

