/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.optional;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Maybe<T> {
    private final Optional<T> result;
    private final Optional<Exception> error;

    public static <T> Maybe<T> success(T result) {
        return Maybe.success(Optional.ofNullable(result));
    }

    public static <T> Maybe<T> success(Optional<T> result) {
        return new Maybe<T>(result, Optional.empty());
    }

    public static <T> Maybe<T> failure(Exception error) {
        return new Maybe(Optional.empty(), Optional.ofNullable(error));
    }

    public static <T> Maybe<T> failure(String errorMessage) {
        return Maybe.failure(new RuntimeException(errorMessage));
    }

    private Maybe(Optional<T> result, Optional<Exception> error) {
        this.result = result;
        this.error = error;
    }

    public boolean hasSucceeded() {
        return this.error.isEmpty();
    }

    public boolean hasFailed() {
        return !this.hasSucceeded();
    }

    public Optional<T> optionalResult() {
        return this.result;
    }

    public T resultOr(T fallback) {
        return this.optionalResult().orElse(fallback);
    }

    public T result() {
        return this.optionalResult().get();
    }

    public Optional<Exception> optionalError() {
        return this.error;
    }

    public Exception error() {
        return this.optionalError().orElse(new RuntimeException("Unbekannter Fehler"));
    }

    public T resultOrError() throws Exception {
        return this.optionalResult().orElseThrow(this::error);
    }

    public <U> Maybe<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.hasFailed()) {
            return Maybe.failure(this.error());
        }
        return Maybe.success(this.optionalResult().map(mapper::apply));
    }

    public void ifSuccessful(Consumer<Optional<T>> action) {
        if (this.hasSucceeded()) {
            action.accept(this.optionalResult());
        }
    }

    public void ifFailed(Consumer<Exception> action) {
        if (this.hasFailed()) {
            action.accept(this.error());
        }
    }

    public void onCompletion(Consumer<Optional<T>> successful, Consumer<Exception> failed) {
        this.ifSuccessful(successful);
        this.ifFailed(failed);
    }

    public static boolean allSucceeded(Maybe<?> ... conditions) {
        for (Maybe<?> each : conditions) {
            if (!each.hasFailed()) continue;
            return false;
        }
        return true;
    }
}

