/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import com.schneide.base.datatypes.collections.iterator.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class ExpandingIterator<INPUT, OUTPUT>
implements Iterator<OUTPUT> {
    private final Iterator<INPUT> source;
    private boolean initialCall;
    private Iterator<OUTPUT> next;
    private final Function<INPUT, Iterable<OUTPUT>> expansion;

    public ExpandingIterator(Iterator<INPUT> source, Function<INPUT, Iterable<OUTPUT>> expansion) {
        this.source = source;
        this.expansion = expansion;
        this.next = new EmptyIterator<OUTPUT>();
        this.initialCall = true;
    }

    @Override
    public boolean hasNext() {
        if (this.initialCall) {
            this.fillQueue();
        }
        return this.next.hasNext();
    }

    private void fillQueue() {
        this.initialCall = false;
        if (this.source.hasNext()) {
            Iterable<OUTPUT> nextItems = this.expansion.apply(this.source.next());
            this.next = nextItems.iterator();
        }
    }

    @Override
    public OUTPUT next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available.");
        }
        OUTPUT result = this.next.next();
        if (!this.next.hasNext()) {
            this.fillQueue();
        }
        return result;
    }
}

