/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterable;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.LastOf;
import com.schneide.base.datatypes.collections.Matcher;
import com.schneide.base.datatypes.collections.iterable.AppendedIterables;
import com.schneide.base.datatypes.collections.iterable.ForEachInIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class IterableUtil {
    private IterableUtil() {
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return !iterable.iterator().hasNext();
    }

    public static boolean hasContent(Iterable<?> iterable) {
        return !IterableUtil.isEmpty(iterable);
    }

    public static <T> Iterable<T> concat(Iterable<T> first, Iterable<T> second) {
        AppendedIterables<T> result = new AppendedIterables<T>();
        result.addPart(first);
        result.addPart(second);
        return result;
    }

    public static <T> ForEachInIterable<T> forEach(Iterable<? extends T> iterable) {
        return new ForEachInIterable<T>(iterable);
    }

    public static <T> T getElementAt(int position, Iterable<T> iterable) throws NoSuchElementException {
        return IterableUtil.elementAt(position, iterable).orElseThrow(() -> new NoSuchElementException("There is no position " + position + " in the Iterable " + String.valueOf(iterable) + " (it's too short, only " + IterableUtil.getSizeFor(iterable) + " elements)."));
    }

    public static <T> Optional<T> elementAt(int position, Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            try {
                return Optional.of(list.get(position));
            }
            catch (IndexOutOfBoundsException e) {
                return Optional.empty();
            }
        }
        int index = 0;
        for (T current : iterable) {
            if (index == position) {
                return Optional.of(current);
            }
            ++index;
        }
        return Optional.empty();
    }

    public static <T> boolean contains(Iterable<T> iterable, T instance) {
        for (T current : iterable) {
            if (!instance.equals(current)) continue;
            return true;
        }
        return false;
    }

    public static <T, I> boolean contains(Iterable<? extends T> iterator, I instance, Matcher<T, I> matcher) {
        if (instance == null || IterableUtil.isEmpty(iterator)) {
            return false;
        }
        for (T element : iterator) {
            if (!matcher.matches(element, instance)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAllInOrder(Iterable<T> iterable, T[] instances) {
        if (instances.length != IterableUtil.getSizeFor(iterable)) {
            return false;
        }
        Iterator<T> iterator = iterable.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T current = iterator.next();
            if (!instances[index].equals(current)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static int getSizeFor(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int result = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static <TYPE> TYPE[] toArray(Class<TYPE> clazz, Iterable<TYPE> iterable) {
        TYPE[] result = ArrayUtil.createArray(clazz, IterableUtil.getSizeFor(iterable));
        Iterator<TYPE> iterator = iterable.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = iterator.next();
        }
        return result;
    }

    public static <TYPE> TYPE lastOf(Iterable<TYPE> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                return null;
            }
            return (TYPE)LastOf.list(list);
        }
        Iterator<TYPE> iterator = iterable.iterator();
        TYPE result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <TYPE> Optional<TYPE> maybeLastOf(Iterable<TYPE> iterable) {
        return Optional.ofNullable(IterableUtil.lastOf(iterable));
    }

    public static <TYPE> Optional<TYPE> maybeFirst(Iterable<TYPE> iterable) {
        try {
            return Optional.of(IterableUtil.firstOf(iterable));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public static <TYPE> TYPE firstOf(Iterable<TYPE> iterable) throws NoSuchElementException {
        return IterableUtil.getElementAt(0, iterable);
    }

    public static <TYPE> Optional<TYPE> first(Iterable<TYPE> iterable) {
        return IterableUtil.elementAt(0, iterable);
    }

    public static <TYPE> Iterable<TYPE> allExceptLast(Iterable<TYPE> iterable) {
        return IterableUtil.slice(iterable, 0, IterableUtil.getSizeFor(iterable) - 1);
    }

    public static <TYPE> Iterable<TYPE> allExceptFirst(Iterable<TYPE> iterable) {
        return IterableUtil.slice(iterable, 1, IterableUtil.getSizeFor(iterable));
    }

    public static <TYPE> Iterable<TYPE> slice(Iterable<TYPE> iterable, int startIndex, int endIndex) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            return list.subList(startIndex, endIndex);
        }
        Iterator<TYPE> iterator = iterable.iterator();
        ArrayList<TYPE> result = new ArrayList<TYPE>();
        int index = 0;
        while (iterator.hasNext()) {
            TYPE current = iterator.next();
            if (index >= startIndex && index < endIndex) {
                result.add(current);
            }
            ++index;
        }
        return result;
    }

    public static <TYPE> Iterable<TYPE> reverse(Iterable<TYPE> iterable) {
        List<TYPE> result = IterableUtil.asList(iterable);
        Collections.reverse(result);
        return result;
    }

    public static <TYPE> List<TYPE> asList(Iterable<TYPE> iterable) {
        ArrayList result = new ArrayList();
        CollectionUtil.addAll(result, iterable);
        return result;
    }

    public static <TYPE> Vector<TYPE> asVector(Iterable<TYPE> iterable) {
        Vector<TYPE> result = new Vector<TYPE>(IterableUtil.asList(iterable));
        return result;
    }

    public static <TYPE> void forEachWithActionInBetween(Iterable<? extends TYPE> iterable, EachActions<TYPE> action) {
        Iterator<TYPE> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            TYPE each = iterator.next();
            action.forEach(each);
            if (!iterator.hasNext()) continue;
            action.inBetween();
        }
    }

    public static <TYPE> Stream<TYPE> asStream(Iterable<TYPE> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).stream();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <TYPE> Set<TYPE> asSet(Iterable<TYPE> iterable) {
        return new HashSet<TYPE>(IterableUtil.asList(iterable));
    }

    public static interface EachActions<TYPE> {
        public void forEach(TYPE var1);

        public void inBetween();
    }
}

