/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterable;

import java.util.Iterator;
import java.util.function.BiFunction;

public class CombinedIterables<ONE, TWO, RESULT>
implements Iterable<RESULT> {
    private final BiFunction<ONE, TWO, RESULT> combinator;
    private final Iterable<ONE> firstSource;
    private final Iterable<TWO> secondSource;

    public CombinedIterables(BiFunction<ONE, TWO, RESULT> combinator, Iterable<ONE> firstSource, Iterable<TWO> secondSource) {
        this.combinator = combinator;
        this.firstSource = firstSource;
        this.secondSource = secondSource;
    }

    @Override
    public Iterator<RESULT> iterator() {
        return new CombinedIterators<ONE, TWO, RESULT>(this.combinator, this.firstSource.iterator(), this.secondSource.iterator());
    }

    private static class CombinedIterators<ONE, TWO, RESULT>
    implements Iterator<RESULT> {
        private final BiFunction<ONE, TWO, RESULT> combinator;
        private final Iterator<ONE> firstSource;
        private final Iterator<TWO> secondSource;

        public CombinedIterators(BiFunction<ONE, TWO, RESULT> combinator, Iterator<ONE> firstSource, Iterator<TWO> secondSource) {
            this.combinator = combinator;
            this.firstSource = firstSource;
            this.secondSource = secondSource;
        }

        @Override
        public boolean hasNext() {
            return this.firstSource.hasNext() && this.secondSource.hasNext();
        }

        @Override
        public RESULT next() {
            ONE one = this.firstSource.next();
            TWO two = this.secondSource.next();
            return this.combinator.apply(one, two);
        }
    }
}

