/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections;

import com.schneide.base.datatypes.collections.Matcher;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <TYPE> TYPE[] copy(TYPE[] array) {
        return array;
    }

    public static <TYPE, SUBTYPE extends TYPE> TYPE[] toArray(Class<TYPE> clazz, Collection<SUBTYPE> collection) {
        return collection.toArray(ArrayUtil.createArray(clazz, collection.size()));
    }

    public static <TYPE, SUBTYPE extends TYPE> TYPE[] toArray(Class<TYPE> clazz, Collection<SUBTYPE> collection, ElementOperation<SUBTYPE> operation) {
        TYPE[] result = ArrayUtil.createArray(clazz, collection.size());
        int index = 0;
        for (SUBTYPE element : collection) {
            result[index] = operation.performOn(element);
            ++index;
        }
        return result;
    }

    public static <T> T[] createArray(Class<T> type, Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return ArrayUtil.toArray(type, list);
    }

    public static <T, S> T[] instanceFilteredArray(Class<T> targetType, S[] sources) {
        ArrayList<S> targets = new ArrayList<S>();
        for (S source : sources) {
            if (!targetType.isInstance(source)) continue;
            targets.add(source);
        }
        return ArrayUtil.createArray(targetType, targets);
    }

    public static <T> T[] createArray(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <T> T[] reverse(T[] array) {
        Object temporaryCache = null;
        for (int i = 0; i < array.length / 2; ++i) {
            temporaryCache = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temporaryCache;
        }
        return array;
    }

    public static <T> T getLastElementOf(T[] array) {
        return array[array.length - 1];
    }

    public static <T> boolean isEmptyOrNull(T[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static <T> boolean isNull(T[] array) {
        return array == null;
    }

    public static <T> boolean isEmpty(T[] array) throws NullPointerException {
        return array.length == 0;
    }

    public static <T> boolean hasContent(T[] array) {
        return !ArrayUtil.isEmptyOrNull(array);
    }

    public static <T> boolean contains(T[] array, T instance) {
        if (instance == null || ArrayUtil.isEmptyOrNull(array)) {
            return false;
        }
        for (T element : array) {
            if (!instance.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static <T, I> boolean contains(T[] array, I instance, Matcher<T, I> matcher) {
        if (instance == null || ArrayUtil.isEmptyOrNull(array)) {
            return false;
        }
        for (T element : array) {
            if (!matcher.matches(element, instance)) continue;
            return true;
        }
        return false;
    }

    public static <T, I> T getInstance(T[] array, I instance, Matcher<T, I> matcher) throws NoSuchElementException {
        if (instance == null) {
            throw new NoSuchElementException("Cannot search for null instance");
        }
        if (ArrayUtil.isEmptyOrNull(array)) {
            throw new NoSuchElementException("Array must not be null or empty");
        }
        for (T element : array) {
            if (!matcher.matches(element, instance)) continue;
            return element;
        }
        throw new NoSuchElementException("No element found matching instance");
    }

    public static <T> int indexOf(T[] array, T instance) {
        if (instance == null || ArrayUtil.isEmptyOrNull(array)) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!instance.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T, U> boolean isSameSize(T[] array1, U[] array2) {
        return ArrayUtil.getSizeOf(array1) == ArrayUtil.getSizeOf(array2);
    }

    private static <T> int getSizeOf(T[] array) {
        if (ArrayUtil.isNull(array)) {
            return -1;
        }
        return array.length;
    }

    public static <T> boolean isEqualWithOrder(T[] array1, T[] array2) {
        if (ArrayUtil.isNull(array1) || ArrayUtil.isNull(array2)) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] remove(T[] array, T instance) {
        return ArrayUtil.remove(array, instance, instance.getClass());
    }

    public static <T> T[] remove(T[] array, T instance, Class<T> clazz) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        list.remove(instance);
        return ArrayUtil.createArray(clazz, list);
    }

    public static <T> T[] add(T[] array, T instance) {
        ArrayList<T> list = new ArrayList<T>(array.length + 1);
        Collections.addAll(list, array);
        list.add(instance);
        return ArrayUtil.createArray(instance.getClass(), list);
    }

    public static <T> boolean isIntersectionEmptyOrNull(T[] array, Collection<T> collection) {
        if (ArrayUtil.isEmptyOrNull(array) || null == collection || collection.isEmpty()) {
            return true;
        }
        for (T element : array) {
            if (!collection.contains(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isIntersectionEmptyOrNull(T[] array1, T[] array2) {
        if (ArrayUtil.isEmptyOrNull(array1) || ArrayUtil.isEmptyOrNull(array2)) {
            return true;
        }
        for (T element : array1) {
            if (!ArrayUtil.contains(array2, element)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] subArray(T[] array, int startIndex, int length) {
        ?[] result = ArrayUtil.createArray(array.getClass().getComponentType(), length);
        System.arraycopy(array, startIndex, result, 0, length);
        return result;
    }

    public static <T> Iterator<T> createIterator(T[] array) {
        return Arrays.asList(array).iterator();
    }

    public static <T> boolean isValidIndex(int index, T[] array) {
        return index >= 0 && index < array.length;
    }

    public static <T> Iterable<T> elementsOf(T[] array) {
        if (null == array) {
            return new EmptyIterable();
        }
        return Arrays.asList(array);
    }

    public static interface ElementOperation<SUBTYPE> {
        public SUBTYPE performOn(SUBTYPE var1);
    }
}

