/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.data.renderer.Converter;

public final class ArrayConverter {
    public static final Converter<Object, String> OBJECT_TO_STRING_CONVERTER = value -> {
        if (null == value) {
            return null;
        }
        return String.valueOf(value);
    };

    private ArrayConverter() {
    }

    public static <SOURCETYPE, TARGETTYPE> TARGETTYPE[] convert(SOURCETYPE[] array, Converter<SOURCETYPE, TARGETTYPE> converter, Class<TARGETTYPE> targetClass) {
        TARGETTYPE[] result = ArrayUtil.createArray(targetClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = converter.convert(array[i]);
        }
        return result;
    }

    public static <SOURCETYPE, TARGETTYPE> TARGETTYPE[] convert(Iterable<SOURCETYPE> source, Converter<SOURCETYPE, TARGETTYPE> converter, Class<TARGETTYPE> targetClass) {
        TARGETTYPE[] result = ArrayUtil.createArray(targetClass, IterableUtil.getSizeFor(source));
        int index = 0;
        for (SOURCETYPE each : source) {
            result[index] = converter.convert(each);
            ++index;
        }
        return result;
    }
}

