/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes;

import com.schneide.base.datatypes.Cache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MaximumSizedCache<K, V>
extends Cache<K, V> {
    private static final long serialVersionUID = -7894604149625340579L;
    private final int maximumSize;

    public MaximumSizedCache(int maximumSize) {
        super(new LinkedHashMap());
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstanceFor(K key, V value) {
        Map map = this.cache();
        synchronized (map) {
            super.addInstanceFor(key, value);
            this.ensureMaximumSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillCache(Map<K, V> map) {
        Map map2 = this.cache();
        synchronized (map2) {
            super.fillCache(map);
            this.ensureMaximumSize();
        }
    }

    private void ensureMaximumSize() {
        int moreThanAllowed = this.cache().size() - this.maximumSize;
        if (moreThanAllowed > 0) {
            this.shortenBy(moreThanAllowed);
        }
    }

    private void shortenBy(int amount) {
        Iterator iterator = this.cache().entrySet().iterator();
        for (int counter = amount; counter > 0 && iterator.hasNext(); --counter) {
            iterator.next();
            iterator.remove();
        }
    }
}

