/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes;

import java.util.HashMap;
import java.util.Map;

public class DataStorage {
    private final String denotation;
    private final Map<Object, Object> dataMap;

    public DataStorage() {
        this("");
    }

    public DataStorage(String denotation) {
        this.denotation = denotation;
        this.dataMap = new HashMap<Object, Object>();
    }

    public String getDenotation() {
        return this.denotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDataValue(Object key) {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            return this.dataMap.get(key);
        }
    }

    public Object getObject(Object key) {
        return this.getDataValue(key);
    }

    public String getString(Object key) {
        return (String)this.getDataValue(key);
    }

    public int getInt(Object key) {
        return (Integer)this.getDataValue(key);
    }

    public float getFloat(Object key) {
        return ((Float)this.getDataValue(key)).floatValue();
    }

    public double getDouble(Object key) {
        return (Double)this.getDataValue(key);
    }

    public boolean getBoolean(Object key) {
        return (Boolean)this.getDataValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDataValue(Object key, Object value) {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            this.dataMap.put(key, value);
        }
    }

    public void setObject(Object key, Object value) {
        this.setDataValue(key, value);
    }

    public void setString(Object key, String value) {
        this.setDataValue(key, value);
    }

    public void setInt(Object key, int value) {
        this.setDataValue(key, value);
    }

    public void setFloat(Object key, float value) {
        this.setDataValue(key, Float.valueOf(value));
    }

    public void setDouble(Object key, double value) {
        this.setDataValue(key, value);
    }

    public void setBoolean(Object key, boolean value) {
        this.setDataValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(Object key) {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            return this.dataMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(Object key) {
        Map<Object, Object> map = this.dataMap;
        synchronized (map) {
            return this.dataMap.remove(key) != null;
        }
    }
}

