/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.util.EqualsBuilder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class Cache<K, V>
extends LoggedObject
implements EqualsBuilder.EqualComparable,
Serializable {
    private static final long serialVersionUID = -3714520015315045485L;
    private final Map<K, V> cache;

    public Cache() {
        this(new HashMap());
    }

    protected Cache(Map<K, V> initialData) {
        this.cache = initialData;
    }

    public Iterable<Object> getValuesToCompare() {
        return new SingleElementIterable<Object>(this.cache());
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual(this, obj);
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<K, V> map = this.cache();
        synchronized (map) {
            return this.cache().isEmpty();
        }
    }

    protected final Map<K, V> cache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getCopyOf() {
        Map<K, V> map = this.cache();
        synchronized (map) {
            HashMap<K, V> copy = new HashMap<K, V>();
            copy.putAll(this.cache());
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceFor(K key, V value) {
        Map<K, V> map = this.cache();
        synchronized (map) {
            this.cache().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCache(Map<K, V> map) {
        Map<K, V> map2 = this.cache();
        synchronized (map2) {
            this.cache().putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getCachedInstanceFor(K key) throws NoSuchElementException {
        Map<K, V> map = this.cache();
        synchronized (map) {
            if (!this.hasCachedInstanceFor(key)) {
                throw new NoSuchElementException("No cached instance found for " + String.valueOf(key));
            }
            return this.cache().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheFor(K key) {
        Map<K, V> map = this.cache();
        synchronized (map) {
            this.cache().remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<K, V> map = this.cache();
        synchronized (map) {
            this.cache().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getInstanceFor(K key) throws ValueCreationException {
        Map<K, V> map = this.cache();
        synchronized (map) {
            if (this.hasCachedInstanceFor(key)) {
                return this.getCachedInstanceFor(key);
            }
            V value = this.createInstanceFor(key);
            if (null == value) {
                throw new ValueCreationException("Will not cache a null value for " + String.valueOf(key));
            }
            this.addInstanceFor(key, value);
            return value;
        }
    }

    protected abstract V createInstanceFor(K var1) throws ValueCreationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCachedInstanceFor(K key) {
        Map<K, V> map = this.cache();
        synchronized (map) {
            return this.cache().containsKey(key);
        }
    }

    public static class ValueCreationException
    extends RuntimeException {
        private static final long serialVersionUID = -2184726231527037992L;

        public ValueCreationException(Throwable cause) {
            super(cause);
        }

        public ValueCreationException(String message, Throwable cause) {
            super(message, cause);
        }

        public ValueCreationException(String message) {
            super(message);
        }
    }
}

