/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.configuration.relocation;

import com.schneide.base.configuration.domain.ConfigurationLocationOf;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.util.Copy;
import com.schneide.base.system.Base;
import java.io.IOException;

public final class RelocateConfiguration {
    private final VirtualFile source;

    private RelocateConfiguration(VirtualFile source) {
        this.source = source;
    }

    public static RelocateConfiguration from(VirtualFile sourceDirectory) {
        return new RelocateConfiguration(sourceDirectory);
    }

    public void to(VirtualFile targetDirectory) throws IOException {
        if (!this.source.isDirectory()) {
            return;
        }
        if (!targetDirectory.isDirectory()) {
            targetDirectory.createAsDirectory();
        }
        ((Copy.RecursiveCopy)((Copy.RecursiveCopy)Copy.all().butExisting()).from(this.source)).to(targetDirectory);
    }

    public static void withDefaultLocations() throws IOException {
        RelocateConfiguration relocation = RelocateConfiguration.from(ConfigurationLocationOf.internals().getChild("factory_settings"));
        relocation.to(ConfigurationLocationOf.settings());
    }

    public static void silently() {
        try {
            RelocateConfiguration.withDefaultLocations();
        }
        catch (IOException e) {
            Base.getDefaultLogger().fatal("Could not relocate system configuration. Cannot start system.", e);
        }
    }
}

